/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.internal;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.database.dao.ExternalSystemRepository;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.ws.converter.ExternalSystemResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.externalsystem.ExternalSystemResource;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/api-internal"})
@PreAuthorize(value="hasRole('COMPONENT')")
public class InternalApiController {
    @Autowired
    private ExternalSystemRepository externalSystemRepository;
    @Autowired
    private Provider<ExternalSystemResourceAssembler> externalSystemResourceAssembler;

    @RequestMapping(value={"/external-system/{systemId}"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiIgnore
    public ExternalSystemResource getExternalSystem(@PathVariable String systemId) {
        ExternalSystem externalSystem = (ExternalSystem)this.externalSystemRepository.findOne((Serializable)((Object)systemId));
        BusinessRule.expect((Object)externalSystem, (Predicate)Predicates.notNull()).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{systemId});
        return ((ExternalSystemResourceAssembler)this.externalSystemResourceAssembler.get()).toResource(externalSystem);
    }
}

