/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssembler;
import com.epam.ta.reportportal.ws.converter.builders.UserResourceBuilder;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class UserResourceAssembler
extends PagedResourcesAssembler<User, UserResource> {
    @Autowired
    private Provider<UserResourceBuilder> builder;

    public UserResource toResource(User user) {
        return (UserResource)((UserResourceBuilder)this.builder.get()).addUser(user).build();
    }

    public com.epam.ta.reportportal.ws.model.Page<UserResource> toPagedResources(Page<User> content, Project project) {
        Map usersConfig = project.getUsers();
        String entryType = project.getConfiguration().getEntryType().name();
        com.epam.ta.reportportal.ws.model.Page userResources = this.toPagedResources(content);
        for (UserResource userResource : userResources) {
            HashMap<String, UserResource.AssignedProject> assignedProjects = new HashMap<String, UserResource.AssignedProject>();
            UserResource.AssignedProject assignedProject = new UserResource.AssignedProject();
            assignedProject.setProposedRole(((Project.UserConfig)usersConfig.get(userResource.getUserId())).getProposedRole().name());
            assignedProject.setProjectRole(((Project.UserConfig)usersConfig.get(userResource.getUserId())).getProjectRole().name());
            assignedProject.setEntryType(entryType);
            assignedProjects.put(project.getId(), assignedProject);
            userResource.setAssignedProjects(assignedProjects);
        }
        return userResources;
    }
}

