/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.entity.BinaryContent;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.LogLevel;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.ws.converter.builders.Builder;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class LogBuilder
extends Builder<Log> {
    public LogBuilder addSaveLogRQ(SaveLogRQ request) {
        if (request != null) {
            Log log = (Log)this.getObject();
            if (null != request.getMessage()) {
                log.setLogMsg(request.getMessage());
            } else {
                log.setLogMsg("NULL");
            }
            log.setLogTime(request.getLogTime());
            if (null != request.getLevel()) {
                log.setLevel(LogLevel.toLevelOrUnknown((String)request.getLevel()));
            }
        }
        return this;
    }

    public LogBuilder addBinaryContent(BinaryContent binaryContent) {
        ((Log)this.getObject()).setBinaryContent(binaryContent);
        return this;
    }

    public LogBuilder addTestItem(TestItem testItem) {
        if (null != testItem) {
            ((Log)this.getObject()).setTestItemRef(testItem.getId());
        }
        return this;
    }

    protected Log initObject() {
        return new Log();
    }
}

