/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectSpecific;
import com.epam.ta.reportportal.database.entity.StatisticsCalculationStrategy;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.database.entity.project.EntryType;
import com.epam.ta.reportportal.database.entity.project.InterruptionJobDelay;
import com.epam.ta.reportportal.database.entity.project.KeepLogsDelay;
import com.epam.ta.reportportal.database.entity.project.KeepScreenshotsDelay;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.statistics.StatisticSubType;
import com.epam.ta.reportportal.ws.converter.converters.EmailConfigConverters;
import com.epam.ta.reportportal.ws.model.project.CreateProjectRQ;
import com.epam.ta.reportportal.ws.model.project.ProjectConfiguration;
import com.epam.ta.reportportal.ws.model.project.ProjectResource;
import com.epam.ta.reportportal.ws.model.project.config.IssueSubTypeResource;
import com.epam.ta.reportportal.ws.model.project.email.ProjectEmailConfigDTO;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ProjectConverter {
    public static final Function<CreateProjectRQ, Project> TO_MODEL = request -> {
        Preconditions.checkNotNull((Object)request);
        Project project = new Project();
        project.setName(request.getProjectName().trim());
        project.setCreationDate(new Date());
        project.getConfiguration().setEntryType((EntryType)EntryType.findByName((String)request.getEntryType()).orElse(null));
        Optional.ofNullable(request.getCustomer()).ifPresent(arg_0 -> ((Project)project).setCustomer(arg_0));
        Optional.ofNullable(request.getAddInfo()).ifPresent(arg_0 -> ((Project)project).setAddInfo(arg_0));
        project.getConfiguration().setExternalSystem((List)Lists.newArrayList());
        project.getConfiguration().setProjectSpecific(ProjectSpecific.DEFAULT);
        project.getConfiguration().setInterruptJobTime(InterruptionJobDelay.ONE_DAY.getValue());
        project.getConfiguration().setKeepLogs(KeepLogsDelay.THREE_MONTHS.getValue());
        project.getConfiguration().setKeepScreenshots(KeepScreenshotsDelay.TWO_WEEKS.getValue());
        project.getConfiguration().setIsAutoAnalyzerEnabled(false);
        project.getConfiguration().setStatisticsCalculationStrategy(StatisticsCalculationStrategy.STEP_BASED);
        ProjectUtils.setDefaultEmailCofiguration((Project)project);
        project.setUsers((Map)Maps.newHashMap());
        return project;
    };
    public static final Function<Project, ProjectResource> TO_RESOURCE = model -> {
        Preconditions.checkNotNull((Object)model);
        ProjectResource resource = new ProjectResource();
        resource.setProjectId(model.getId());
        resource.setCustomer(model.getCustomer());
        resource.setAddInfo(model.getAddInfo());
        resource.setCreationDate(model.getCreationDate());
        Map<String, ProjectResource.ProjectUser> users = model.getUsers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, user -> {
            ProjectResource.ProjectUser one = new ProjectResource.ProjectUser();
            one.setProjectRole(((Project.UserConfig)user.getValue()).getProjectRole().name());
            one.setProposedRole(((Project.UserConfig)user.getValue()).getProposedRole().name());
            return one;
        }));
        resource.setUsers(users);
        ProjectConfiguration configuration = new ProjectConfiguration();
        configuration.setEntry(model.getConfiguration().getEntryType().name());
        configuration.setProjectSpecific(model.getConfiguration().getProjectSpecific().name());
        configuration.setKeepLogs(model.getConfiguration().getKeepLogs());
        configuration.setInterruptJobTime(model.getConfiguration().getInterruptJobTime());
        configuration.setKeepScreenshots(model.getConfiguration().getKeepScreenshots());
        configuration.setIsAAEnabled(model.getConfiguration().getIsAutoAnalyzerEnabled().booleanValue());
        configuration.setStatisticCalculationStrategy(model.getConfiguration().getStatisticsCalculationStrategy().name());
        configuration.setEmailConfig((ProjectEmailConfigDTO)EmailConfigConverters.TO_RESOURCE.apply(model.getConfiguration().getEmailConfig()));
        Map<String, List> result = model.getConfiguration().getSubTypes().entrySet().stream().collect(Collectors.toMap(entry -> ((TestItemIssueType)entry.getKey()).getValue(), entry -> ((List)entry.getValue()).stream().map(TO_SUBTYPE_RESOURCE).collect(Collectors.toList())));
        configuration.setSubTypes(result);
        resource.setConfiguration(configuration);
        return resource;
    };
    static final Function<StatisticSubType, IssueSubTypeResource> TO_SUBTYPE_RESOURCE = statisticSubType -> {
        IssueSubTypeResource issueSubTypeResource = new IssueSubTypeResource();
        issueSubTypeResource.setLocator(statisticSubType.getLocator());
        issueSubTypeResource.setTypeRef(statisticSubType.getTypeRef());
        issueSubTypeResource.setLongName(statisticSubType.getLongName());
        issueSubTypeResource.setShortName(statisticSubType.getShortName());
        issueSubTypeResource.setColor(statisticSubType.getHexColor());
        return issueSubTypeResource;
    };

    private ProjectConverter() {
    }
}

