/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.auth.permissions;

import com.epam.ta.reportportal.auth.permissions.Permission;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.io.Serializable;
import java.util.function.Predicate;
import javax.inject.Provider;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;

abstract class BaseProjectPermission
implements Permission {
    @Autowired
    private Provider<ProjectRepository> projectRepository;

    BaseProjectPermission() {
    }

    public boolean isAllowed(Authentication authentication, Object projectName) {
        if (!authentication.isAuthenticated()) {
            return false;
        }
        String project = (String)projectName;
        Project p = (Project)((ProjectRepository)this.projectRepository.get()).findOne((Serializable)((Object)project));
        BusinessRule.expect((Object)p, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{project});
        BusinessRule.expect((Object)p.getUsers(), (Predicate)Preconditions.containsKey((Object)authentication.getName())).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        return this.checkAllowed(authentication, p);
    }

    protected abstract boolean checkAllowed(@NotNull Authentication var1, @NotNull Project var2);
}

