/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.externalsystem;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.externalsystem.ExternalSystemStrategy;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.item.issue.ExternalSystemType;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.YesNoRS;
import com.epam.ta.reportportal.ws.model.externalsystem.PostFormField;
import com.epam.ta.reportportal.ws.model.externalsystem.PostTicketRQ;
import com.epam.ta.reportportal.ws.model.externalsystem.Ticket;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

public class ExternalSystemEurekaDelegate
implements ExternalSystemStrategy {
    @Autowired
    private DiscoveryClient discoveryClient;
    private final RestTemplate eurekaTemplate;

    public ExternalSystemEurekaDelegate(RestTemplate eurekaTemplate) {
        this.eurekaTemplate = eurekaTemplate;
    }

    void checkAvailable(ExternalSystemType systemType) {
        this.getServiceInstance(systemType);
    }

    public boolean connectionTest(ExternalSystem system) {
        return ((YesNoRS)this.eurekaTemplate.postForObject(this.getServiceInstance(system.getExternalSystemType()).getUri().toString() + "/check", (Object)system, YesNoRS.class, new Object[]{system.getId()})).getIs();
    }

    public Optional<Ticket> getTicket(String id, ExternalSystem system) {
        return Optional.of(this.eurekaTemplate.getForObject(this.getServiceInstance(system.getExternalSystemType()).getUri().toString() + "/{systemId}/ticket/{id}", Ticket.class, new Object[]{system.getId(), id}));
    }

    public Ticket submitTicket(PostTicketRQ ticketRQ, ExternalSystem system) {
        return (Ticket)this.eurekaTemplate.postForObject(this.getServiceInstance(system.getExternalSystemType()).getUri().toString() + "/{systemId}/ticket", (Object)ticketRQ, Ticket.class, new Object[]{system.getId()});
    }

    public List<PostFormField> getTicketFields(String issueType, ExternalSystem system) {
        return (List)this.eurekaTemplate.exchange(this.getServiceInstance(system.getExternalSystemType()).getUri().toString() + "/{systemId}/ticket/{issueType}/fields", HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[]{system.getId(), issueType}).getBody();
    }

    private ServiceInstance getServiceInstance(ExternalSystemType externalSystem) {
        String externalSystemType = externalSystem.name().toLowerCase();
        Optional<ServiceInstance> delegate = this.discoveryClient.getServices().stream().flatMap(service -> this.discoveryClient.getInstances(service).stream()).filter(instance -> externalSystemType.equals(instance.getMetadata().get("extension"))).findAny();
        BusinessRule.expect(delegate, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.UNABLE_INTERACT_WITH_EXTRERNAL_SYSTEM, new Object[]{"External system with type " + externalSystem + " is not deployed or not available"});
        return delegate.get();
    }
}

