/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.externalsystem.handler.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.externalsystem.ExternalSystemStrategy;
import com.epam.ta.reportportal.core.externalsystem.StrategyProvider;
import com.epam.ta.reportportal.core.externalsystem.handler.ICreateExternalSystemHandler;
import com.epam.ta.reportportal.database.dao.ExternalSystemRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.AuthType;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.issue.ExternalSystemType;
import com.epam.ta.reportportal.events.ExternalSystemCreatedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.converter.builders.ExternalSystemBuilder;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.externalsystem.CreateExternalSystemRQ;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class CreateExternalSystemHandler
implements ICreateExternalSystemHandler {
    @Autowired
    private StrategyProvider strategyProvider;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private ExternalSystemRepository externalSystemRepository;
    @Autowired
    private Provider<ExternalSystemBuilder> builder;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public EntryCreatedRS createExternalSystem(CreateExternalSystemRQ createRQ, String projectName, String username) {
        ExternalSystem createOne;
        Project project = this.projectRepository.findByName(projectName);
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        if (createRQ.getUrl().endsWith("/")) {
            createRQ.setUrl(createRQ.getUrl().substring(0, createRQ.getUrl().length() - 1));
        }
        String sysUrl = createRQ.getUrl();
        String sysProject = createRQ.getProject();
        ExternalSystem exist = this.externalSystemRepository.findByUrlAndProject(sysUrl, sysProject, projectName);
        BusinessRule.expect((Object)exist, (Predicate)Predicates.isNull()).verify(ErrorType.EXTERNAL_SYSTEM_ALREADY_EXISTS, new Object[]{sysUrl + " & " + sysProject});
        ExternalSystemStrategy externalSystemStrategy = this.strategyProvider.getStrategy(createRQ.getExternalSystemType());
        BusinessRule.expect((Object)externalSystemStrategy, (Predicate)Predicates.notNull()).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{createRQ.getExternalSystemType()});
        ExternalSystem details = new ExternalSystem();
        details.setUrl(createRQ.getUrl());
        details.setProject(createRQ.getProject());
        details.setAccessKey(createRQ.getAccessKey());
        details.setExternalSystemType((ExternalSystemType)ExternalSystemType.findByName((String)createRQ.getExternalSystemType()).get());
        AuthType authType = AuthType.findByName((String)createRQ.getExternalSystemAuth());
        BusinessRule.expect((Object)authType, (Predicate)Predicates.notNull()).verify(ErrorType.INCORRECT_AUTHENTICATION_TYPE, new Object[]{createRQ.getExternalSystemAuth()});
        details.setExternalSystemAuth(authType);
        if (authType.requiresPassword()) {
            details.setUsername(createRQ.getUsername());
            details.setPassword(createRQ.getPassword());
            details.setDomain(createRQ.getDomain());
        }
        BusinessRule.expect((Object)externalSystemStrategy.connectionTest(details), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.UNABLE_INTERACT_WITH_EXTRERNAL_SYSTEM, new Object[]{projectName});
        ExternalSystem newOne = (ExternalSystem)((ExternalSystemBuilder)this.builder.get()).addExternalSystem(createRQ, projectName).build();
        try {
            createOne = (ExternalSystem)this.externalSystemRepository.save((Object)newOne);
            List externalSystemIds = project.getConfiguration().getExternalSystem();
            externalSystemIds.add(createOne.getId());
            project.getConfiguration().setExternalSystem(externalSystemIds);
            this.projectRepository.save(project);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during creating ExternalSystem", (Throwable)e);
        }
        this.eventPublisher.publishEvent((Object)new ExternalSystemCreatedEvent(createOne, username));
        return new EntryCreatedRS(createOne.getId());
    }
}

