/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.history;

import com.epam.ta.reportportal.commons.DbUtils;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.item.history.ITestItemsHistoryService;
import com.epam.ta.reportportal.core.item.history.TestItemsHistoryHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.ws.converter.TestItemResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.TestItemHistoryElement;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestItemsHistoryHandlerImpl
implements TestItemsHistoryHandler {
    private TestItemRepository testItemRepository;
    private ProjectRepository projectRepository;
    private TestItemResourceAssembler itemResourceAssembler;
    private ITestItemsHistoryService historyServiceStrategy;

    @Autowired
    public void setTestItemRepository(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    @Autowired
    public void setItemBuilder(TestItemResourceAssembler itemResourceAssembler) {
        this.itemResourceAssembler = itemResourceAssembler;
    }

    @Autowired
    public void setTestItemHistoryService(ITestItemsHistoryService testItemHistoryService) {
        this.historyServiceStrategy = testItemHistoryService;
    }

    public List<TestItemHistoryElement> getItemsHistory(String projectName, String[] startPointsIds, int historyDepth, boolean showBrokenLaunches) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        Predicate<Integer> greaterThan = t -> t > 0;
        Predicate<Integer> lessThan = t -> t < 31;
        String historyDepthMessage = "Items history depth should be greater than '0' and lower than '31'";
        BusinessRule.expect((Object)historyDepth, greaterThan.and(lessThan)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{historyDepthMessage});
        BusinessRule.expect((Object)startPointsIds.length, t -> t < 31).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"History size should be less than '31' test items."});
        ArrayList listIds = Lists.newArrayList((Object[])startPointsIds);
        List itemsForHistory = this.historyServiceStrategy.loadItems((List)listIds);
        this.historyServiceStrategy.validateItems(itemsForHistory, (List)listIds, projectName);
        List launches = this.historyServiceStrategy.loadLaunches(historyDepth, ((TestItem)itemsForHistory.get(0)).getLaunchRef(), projectName, showBrokenLaunches);
        List historyLaunchesIds = launches.stream().map(Launch::getId).collect(Collectors.toList());
        List history = this.testItemRepository.loadItemsHistory(itemsForHistory, historyLaunchesIds, this.loadParentIds((TestItem)itemsForHistory.get(0), historyLaunchesIds));
        Map<String, List<TestItem>> groupedItems = history.stream().collect(Collectors.groupingBy(TestItem::getLaunchRef));
        return launches.stream().map(launch -> this.buildHistoryElement(launch, (List)groupedItems.get(launch.getId()))).collect(Collectors.toList());
    }

    TestItemHistoryElement buildHistoryElement(Launch launch, List<TestItem> testItems) {
        List<Object> resources = new ArrayList();
        if (testItems != null) {
            resources = testItems.stream().map(item -> this.itemResourceAssembler.toResource(item, launch.getStatus().name())).collect(Collectors.toList());
        }
        TestItemHistoryElement testItemHistoryElement = new TestItemHistoryElement();
        testItemHistoryElement.setLaunchId(launch.getId());
        testItemHistoryElement.setLaunchNumber(launch.getNumber().toString());
        testItemHistoryElement.setStartTime(String.valueOf(launch.getStartTime().getTime()));
        testItemHistoryElement.setResources(resources);
        testItemHistoryElement.setLaunchStatus(launch.getStatus().name());
        return testItemHistoryElement;
    }

    private List<String> loadParentIds(TestItem testItem, List<String> launchesIds) {
        if (testItem == null || testItem.getParent() == null) {
            return null;
        }
        TestItem parent = (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItem.getParent()));
        BusinessRule.expect((Object)parent, (Predicate)Predicates.notNull()).verify(ErrorType.TEST_ITEM_NOT_FOUND, new Object[]{"Unable to find parent for '" + testItem.getId() + "' with ID '" + testItem.getParent() + "'."});
        List history = this.testItemRepository.loadItemsHistory((List)Lists.newArrayList((Object[])new TestItem[]{parent}), launchesIds, null);
        return DbUtils.toIds((Iterable)history);
    }
}

