/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.merge.strategy;

import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategy;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractSuiteMergeStrategy
implements MergeStrategy {
    protected final TestItemRepository testItemRepository;

    public AbstractSuiteMergeStrategy(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    public abstract TestItem mergeTestItems(TestItem var1, List<TestItem> var2);

    public abstract boolean isTestItemAcceptableToMerge(TestItem var1);

    private TestItem moveAllChildTestItems(TestItem itemTarget, TestItem itemSource) {
        for (TestItem childItem : this.testItemRepository.findAllDescendants(itemSource.getId())) {
            childItem.setParent(itemTarget.getId());
            childItem.setLaunchRef(itemTarget.getLaunchRef());
            ArrayList<String> path = new ArrayList<String>(itemTarget.getPath());
            path.add(itemTarget.getId());
            childItem.setPath(path);
            this.setLaunchRefForChilds(childItem, itemTarget.getLaunchRef());
            this.testItemRepository.save((Object)childItem);
        }
        this.updateTargetItemInfo(itemTarget, itemSource);
        this.testItemRepository.delete((Object)itemSource);
        return itemTarget;
    }

    TestItem moveAllChildTestItems(TestItem itemTarget, List<TestItem> items) {
        TestItem result = items.stream().reduce(itemTarget, (arg_0, arg_1) -> this.moveAllChildTestItems(arg_0, arg_1));
        this.mergeAllChildItems(result);
        return result;
    }

    private void setLaunchRefForChilds(TestItem testItemParent, String launchRef) {
        List childItems = this.testItemRepository.findAllDescendants(testItemParent.getId());
        for (TestItem child : childItems) {
            child.setLaunchRef(launchRef);
            ArrayList<String> path = new ArrayList<String>(testItemParent.getPath());
            path.add(testItemParent.getId());
            child.setPath(path);
            this.testItemRepository.save((Object)child);
            if (!child.hasChilds()) continue;
            this.setLaunchRefForChilds(child, launchRef);
        }
    }

    protected void mergeAllChildItems(TestItem testItemParent) {
        List childItems = this.testItemRepository.findAllDescendants(testItemParent.getId());
        List suites = childItems.stream().filter(arg_0 -> this.isTestItemAcceptableToMerge(arg_0)).collect(Collectors.toList());
        suites.stream().collect(Collectors.groupingBy(TestItem::getName)).entrySet().forEach(entry -> this.moveAllChildTestItems((TestItem)((List)entry.getValue()).get(0), ((List)entry.getValue()).subList(1, ((List)entry.getValue()).size())));
    }

    private void updateTargetItemInfo(TestItem target, TestItem source) {
        String result;
        target.setStartTime(target.getStartTime().compareTo(source.getStartTime()) < 0 ? target.getStartTime() : source.getStartTime());
        target.setEndTime(target.getEndTime().compareTo(source.getEndTime()) > 0 ? target.getEndTime() : source.getEndTime());
        Set tags = Stream.concat(Optional.ofNullable(target.getTags()).orElse(Sets.newHashSet()).stream(), Optional.ofNullable(source.getTags()).orElse(Sets.newHashSet()).stream()).collect(Collectors.toSet());
        if (!tags.isEmpty()) {
            target.setTags(tags);
        }
        if (!(result = new StringJoiner("\r\n").add(Optional.ofNullable(target.getItemDescription()).orElse("")).add(Optional.ofNullable(source.getItemDescription()).orElse("")).toString()).isEmpty()) {
            target.setItemDescription(result);
        }
        this.testItemRepository.save((Object)target);
    }
}

