/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.merge.strategy;

import com.epam.ta.reportportal.core.item.merge.strategy.AbstractSuiteMergeStrategy;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DeepMergeStrategy
extends AbstractSuiteMergeStrategy {
    @Autowired
    public DeepMergeStrategy(TestItemRepository testItemRepository) {
        super(testItemRepository);
    }

    public TestItem mergeTestItems(TestItem itemTarget, List<TestItem> items) {
        return this.moveAllChildTestItems(itemTarget, items);
    }

    protected void mergeAllChildItems(TestItem testItemParent) {
        List childItems = this.testItemRepository.findAllDescendants(testItemParent.getId());
        List testItems = childItems.stream().filter(arg_0 -> this.isTestItemAcceptableToMerge(arg_0)).collect(Collectors.toList());
        testItems.stream().collect(Collectors.groupingBy(TestItem::getType, Collectors.groupingBy(TestItem::getName))).entrySet().stream().map(Map.Entry::getValue).collect(HashMap::new, HashMap::putAll, HashMap::putAll).entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList()).forEach(items -> this.moveAllChildTestItems((TestItem)items.get(0), items.subList(1, items.size())));
    }

    public boolean isTestItemAcceptableToMerge(TestItem item) {
        return item.hasChilds();
    }
}

