/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.merge.strategy;

import com.epam.ta.reportportal.core.item.merge.strategy.AbstractSuiteMergeStrategy;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class SuiteMergeStrategy
extends AbstractSuiteMergeStrategy {
    @Autowired
    public SuiteMergeStrategy(TestItemRepository testItemRepository) {
        super(testItemRepository);
    }

    public TestItem mergeTestItems(TestItem itemTarget, List<TestItem> items) {
        return this.moveAllChildTestItems(itemTarget, items);
    }

    public boolean isTestItemAcceptableToMerge(TestItem item) {
        if (!item.getType().sameLevel(TestItemType.SUITE)) {
            return false;
        }
        List childItems = this.testItemRepository.findAllDescendants(item.getId());
        List tests = childItems.stream().filter(child -> !child.getType().sameLevel(TestItemType.SUITE)).collect(Collectors.toList());
        Set names = tests.stream().map(TestItem::getName).collect(Collectors.toSet());
        return names.size() == tests.size();
    }
}

