/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.jasper;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.jasper.GetJasperReportHandler;
import com.epam.ta.reportportal.core.jasper.IGetJasperReportHandler;
import com.epam.ta.reportportal.core.jasper.JasperDataProvider;
import com.epam.ta.reportportal.core.jasper.JasperReportRender;
import com.epam.ta.reportportal.core.jasper.ReportFormat;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.statistics.ExecutionCounter;
import com.epam.ta.reportportal.database.entity.statistics.IssueCounter;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GetJasperReportHandler
implements IGetJasperReportHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetJasperReportHandler.class);
    private static final String LAUNCH_NAME = "LAUNCH_NAME";
    private static final String LAUNCH_DESC = "LAUNCH_DESCRIPTION";
    private static final String LAUNCH_TAGS = "LAUNCH_TAGS";
    private static final String DURATION = "LAUNCH_DURATION";
    private static final String OWNER = "LAUNCH_OWNER";
    private static final String TOTAL = "TOTAL";
    private static final String PASSED = "PASSED";
    private static final String FAILED = "FAILED";
    private static final String SKIPPED = "SKIPPED";
    private static final String AB = "AB";
    private static final String PB = "PB";
    private static final String SI = "SI";
    private static final String ND = "ND";
    private static final String TI = "TI";
    private static final String TEST_ITEMS = "TEST_ITEMS";
    private final LaunchRepository launchRepository;
    private final UserRepository userRepository;
    private final JasperReportRender reportRender;
    private final JasperDataProvider dataProvider;

    @Autowired
    public GetJasperReportHandler(JasperReportRender reportRender, UserRepository userRepository, JasperDataProvider dataProvider, LaunchRepository launchRepository) {
        this.reportRender = (JasperReportRender)Preconditions.checkNotNull((Object)reportRender);
        this.userRepository = (UserRepository)Preconditions.checkNotNull((Object)userRepository);
        this.dataProvider = (JasperDataProvider)Preconditions.checkNotNull((Object)dataProvider);
        this.launchRepository = (LaunchRepository)Preconditions.checkNotNull((Object)launchRepository);
    }

    public JasperPrint getLaunchDetails(String launchId, String username) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        BusinessRule.expect((Object)launch, (Predicate)Predicates.not((Predicate)com.epam.ta.reportportal.commons.Preconditions.IN_PROGRESS)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Launch '{}' has IN_PROGRESS status. Impossible to export such elements.", (Object[])new Object[]{launchId})});
        User user = this.userRepository.findOne(username);
        BusinessRule.expect((Object)user, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{username});
        Map params = this.processLaunchParams(launch);
        User owner = this.userRepository.findOne(launch.getUserRef());
        if (null != owner) {
            params.put("LAUNCH_OWNER", owner.getFullName());
        } else {
            params.put("LAUNCH_OWNER", user.getFullName());
        }
        params.put("TEST_ITEMS", this.dataProvider.getReportSource(launch));
        return this.reportRender.generateReportPrint(params, (JRDataSource)new JREmptyDataSource());
    }

    public ReportFormat getReportFormat(String view) {
        Optional format = ReportFormat.findByName((String)view);
        BusinessRule.expect((Object)format, (Predicate)com.epam.ta.reportportal.commons.Preconditions.IS_PRESENT).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Unexpected report format: {}", (Object[])new Object[]{view})});
        return (ReportFormat)format.get();
    }

    public void writeReport(ReportFormat format, OutputStream outputStream, JasperPrint jasperPrint) throws IOException {
        try {
            switch (1.$SwitchMap$com$epam$ta$reportportal$core$jasper$ReportFormat[format.ordinal()]) {
                case 1: {
                    JasperExportManager.exportReportToPdfStream((JasperPrint)jasperPrint, (OutputStream)outputStream);
                    break;
                }
                case 2: {
                    HtmlExporter exporter = new HtmlExporter();
                    exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    SimpleHtmlExporterOutput exporterOutput = new SimpleHtmlExporterOutput(outputStream);
                    exporter.setExporterOutput((ExporterOutput)exporterOutput);
                    SimpleHtmlReportConfiguration htmlConfig = new SimpleHtmlReportConfiguration();
                    htmlConfig.setWhitePageBackground(Boolean.valueOf(false));
                    htmlConfig.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
                    exporter.setConfiguration((ReportExportConfiguration)htmlConfig);
                    exporter.exportReport();
                    break;
                }
                case 3: {
                    SimpleXlsReportConfiguration configuration = new SimpleXlsReportConfiguration();
                    configuration.setOnePagePerSheet(Boolean.valueOf(false));
                    configuration.setDetectCellType(Boolean.valueOf(true));
                    configuration.setCollapseRowSpan(Boolean.valueOf(false));
                    configuration.setIgnoreGraphics(Boolean.valueOf(true));
                    JRXlsExporter exporterXLS = new JRXlsExporter();
                    exporterXLS.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    exporterXLS.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(outputStream));
                    exporterXLS.setConfiguration((ReportExportConfiguration)configuration);
                    exporterXLS.exportReport();
                }
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (JRException ex) {
            LOGGER.error("Unable to generate report!", (Throwable)ex);
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)" Unexpected issue during report output stream creation: {}", (Object[])new Object[]{ex.getLocalizedMessage()})});
        }
    }

    private static String millisToShortDHMS(long duration) {
        long days = TimeUnit.MILLISECONDS.toDays(duration);
        long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
        String res = days == 0L ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%dd%02d:%02d:%02d", days, hours, minutes, seconds);
        return res;
    }

    private Map<String, Object> processLaunchParams(Launch launch) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("LAUNCH_NAME", launch.getName() + " #" + launch.getNumber());
        params.put("LAUNCH_DESCRIPTION", launch.getDescription() == null ? "" : launch.getDescription());
        params.put("LAUNCH_TAGS", launch.getTags());
        params.put("LAUNCH_DURATION", GetJasperReportHandler.millisToShortDHMS((long)(launch.getEndTime().getTime() - launch.getStartTime().getTime())));
        ExecutionCounter exec = launch.getStatistics().getExecutionCounter();
        params.put("TOTAL", exec.getTotal());
        params.put("PASSED", exec.getPassed());
        params.put("FAILED", exec.getFailed());
        params.put("SKIPPED", exec.getSkipped());
        IssueCounter issue = launch.getStatistics().getIssueCounter();
        params.put("AB", issue.getAutomationBugTotal());
        params.put("PB", issue.getProductBugTotal());
        params.put("SI", issue.getSystemIssueTotal());
        params.put("ND", issue.getNoDefectTotal());
        params.put("TI", issue.getToInvestigateTotal());
        return params;
    }
}

