/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.project.settings.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.project.settings.IGetProjectSettingsHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.ws.converter.ProjectSettingsResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.project.config.ProjectSettingsResource;
import java.io.Serializable;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetProjectSettingsHandler
implements IGetProjectSettingsHandler {
    private ProjectRepository settingsRepo;
    private ProjectSettingsResourceAssembler assembler;

    @Autowired
    public GetProjectSettingsHandler(ProjectRepository projectSettingsRepository, ProjectSettingsResourceAssembler projectSettingsResourceAssembler) {
        this.settingsRepo = projectSettingsRepository;
        this.assembler = projectSettingsResourceAssembler;
    }

    public ProjectSettingsResource getProjectSettings(String projectName) {
        Project settings = (Project)this.settingsRepo.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)settings, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        return this.assembler.toResource(settings);
    }
}

