/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.statistics;

import com.epam.ta.reportportal.core.statistics.StatisticsFacade;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeImpl;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import org.springframework.stereotype.Service;

@Service
public class TestBasedStatisticsFacade
extends StatisticsFacadeImpl
implements StatisticsFacade {
    public TestItem updateExecutionStatistics(TestItem testItem) {
        TestItemType type = testItem.getType();
        if (type.awareStatistics() && type.sameLevel(TestItemType.TEST)) {
            return super.updateExecutionStatistics(testItem);
        }
        return testItem;
    }

    public TestItem resetExecutionStatistics(TestItem testItem) {
        TestItemType type = testItem.getType();
        if (type.awareStatistics()) {
            return super.resetExecutionStatistics(testItem);
        }
        return testItem;
    }

    public TestItem deleteExecutionStatistics(TestItem testItem) {
        TestItemType type = testItem.getType();
        if (type.awareStatistics()) {
            return super.deleteExecutionStatistics(testItem);
        }
        return testItem;
    }

    public TestItem identifyStatus(TestItem testItem) {
        if (testItem.getType().sameLevel(TestItemType.TEST) && this.testItemRepository.hasChildrenWithStatuses(testItem.getId(), new Status[]{Status.FAILED, Status.SKIPPED})) {
            testItem.setStatus(Status.FAILED);
            return testItem;
        }
        return super.identifyStatus(testItem);
    }

    public boolean awareIssue(TestItem testItem) {
        return testItem.getType().sameLevel(TestItemType.TEST);
    }
}

