/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.reportportal.commons.Safe;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.user.ICreateUserHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.RestorePasswordBidRepository;
import com.epam.ta.reportportal.database.dao.UserCreationBidRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.user.RestorePasswordBid;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserCreationBid;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.entity.user.UserType;
import com.epam.ta.reportportal.database.entity.user.UserUtils;
import com.epam.ta.reportportal.database.personal.PersonalProjectService;
import com.epam.ta.reportportal.events.UserCreatedEvent;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.util.Predicates;
import com.epam.ta.reportportal.util.email.EmailService;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.epam.ta.reportportal.ws.converter.builders.UserBuilder;
import com.epam.ta.reportportal.ws.converter.converters.RestorePasswordBidConverter;
import com.epam.ta.reportportal.ws.converter.converters.UserCreationBidConverter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.YesNoRS;
import com.epam.ta.reportportal.ws.model.user.CreateUserBidRS;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQ;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQConfirm;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQFull;
import com.epam.ta.reportportal.ws.model.user.CreateUserRS;
import com.epam.ta.reportportal.ws.model.user.ResetPasswordRQ;
import com.epam.ta.reportportal.ws.model.user.RestorePasswordRQ;
import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class CreateUserHandler
implements ICreateUserHandler {
    static final HashFunction HASH_FUNCTION = Hashing.md5();
    private UserRepository userRepository;
    private ProjectRepository projectRepository;
    @Autowired
    private PersonalProjectService personalProjectService;
    @Autowired
    private MailServiceFactory emailServiceFactory;
    @Autowired
    private UserCreationBidRepository userCreationBidRepository;
    @Autowired
    private RestorePasswordBidRepository restorePasswordBidRepository;
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private Provider<UserBuilder> userBuilder;

    @Autowired
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    @Autowired
    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public CreateUserRS createUserByAdmin(CreateUserRQFull request, String userName, String basicUrl) {
        String newUsername = EntityUtils.normalizeId((String)request.getLogin());
        BusinessRule.expect((Object)this.userRepository.exists((Serializable)((Object)newUsername)), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)false)).verify(ErrorType.USER_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"login='{}'", (Object[])new Object[]{newUsername})});
        BusinessRule.expect((Object)newUsername, Predicates.SPECIAL_CHARS_ONLY.negate()).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Username '{}' consists only of special characters", (Object[])new Object[]{newUsername})});
        String projectName = EntityUtils.normalizeId((String)request.getDefaultProject());
        Project defaultProject = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)defaultProject, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        String email = EntityUtils.normalizeId((String)request.getEmail());
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)email), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{email});
        CreateUserRQConfirm req = new CreateUserRQConfirm();
        req.setDefaultProject(projectName);
        req.setEmail(email);
        req.setFullName(request.getFullName());
        req.setLogin(request.getLogin());
        req.setPassword(request.getPassword());
        Optional userRole = UserRole.findByName((String)request.getAccountRole());
        BusinessRule.expect((Object)userRole.isPresent(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect specified Account Role parameter."});
        User user = (User)((UserBuilder)this.userBuilder.get()).addCreateUserRQ(req).addUserRole((UserRole)userRole.get()).build();
        Optional projectRole = ProjectRole.forName((String)request.getProjectRole());
        BusinessRule.expect((Object)projectRole, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.ROLE_NOT_FOUND, new Object[]{request.getProjectRole()});
        Map projectUsers = defaultProject.getUsers();
        projectUsers.put(user.getId(), Project.UserConfig.newOne().withProjectRole((ProjectRole)projectRole.get()).withProposedRole((ProjectRole)projectRole.get()));
        defaultProject.setUsers(projectUsers);
        CreateUserRS response = new CreateUserRS();
        try {
            this.userRepository.save(user);
            this.projectRepository.addUsers(projectName, projectUsers);
            Project personalProject = this.personalProjectService.generatePersonalProject(user);
            if (!defaultProject.getId().equals(personalProject.getId())) {
                this.projectRepository.save(personalProject);
            }
            Safe.safe(() -> this.emailServiceFactory.getDefaultEmailService(true).sendCreateUserConfirmationEmail(request, basicUrl), e -> response.setWarning(e.getMessage()));
        }
        catch (DuplicateKeyException e2) {
            BusinessRule.fail().withError(ErrorType.USER_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"email='{}'", (Object[])new Object[]{request.getEmail()})});
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while User creating: " + exp.getMessage(), (Throwable)exp);
        }
        this.eventPublisher.publishEvent((Object)new UserCreatedEvent(user, userName));
        response.setLogin(user.getLogin());
        return response;
    }

    public CreateUserBidRS createUserBid(CreateUserRQ request, Principal principal, String emailURL) {
        EmailService emailService = this.emailServiceFactory.getDefaultEmailService(true);
        User creator = this.userRepository.findOne(principal.getName());
        BusinessRule.expect((Object)creator, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        String email = EntityUtils.normalizeId((String)request.getEmail());
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)email), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{email});
        User email_user = this.userRepository.findByEmail(request.getEmail());
        BusinessRule.expect((Object)email_user, (Predicate)com.epam.ta.reportportal.commons.Predicates.isNull()).verify(ErrorType.USER_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"email={}", (Object[])new Object[]{request.getEmail()})});
        Project defaultProject = (Project)this.projectRepository.findOne((Serializable)((Object)EntityUtils.normalizeId((String)request.getDefaultProject())));
        BusinessRule.expect((Object)defaultProject, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{request.getDefaultProject()});
        Project.UserConfig userConfig = (Project.UserConfig)defaultProject.getUsers().get(principal.getName());
        List projects = this.projectRepository.findUserProjects(principal.getName());
        BusinessRule.expect((Object)defaultProject, (Predicate)com.epam.ta.reportportal.commons.Predicates.not((Predicate)com.epam.ta.reportportal.commons.Predicates.in((Collection)projects))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        Optional role = ProjectRole.forName((String)request.getRole());
        BusinessRule.expect((Object)role, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.ROLE_NOT_FOUND, new Object[]{request.getRole()});
        if (creator.getRole() != UserRole.ADMINISTRATOR) {
            BusinessRule.expect((Object)userConfig.getProjectRole().sameOrHigherThan((ProjectRole)role.get()), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        UserCreationBid bid = (UserCreationBid)UserCreationBidConverter.TO_USER.apply(request);
        try {
            this.userCreationBidRepository.save((Object)bid);
        }
        catch (Exception e) {
            throw new ReportPortalException("Error while user creation bid registering.", (Throwable)e);
        }
        StringBuilder emailLink = new StringBuilder(emailURL);
        try {
            emailLink.append("/ui/#registration?uuid=");
            emailLink.append(bid.getId());
            emailService.sendCreateUserConfirmationEmail("User registration confirmation", new String[]{bid.getEmail()}, emailLink.toString());
        }
        catch (Exception e) {
            BusinessRule.fail().withError(ErrorType.EMAIL_CONFIGURATION_IS_INCORRECT, new Object[]{Suppliers.formattedSupplier((String)("Unable to send email for bid '{}'." + e.getMessage()), (Object[])new Object[]{bid.getId()})});
        }
        CreateUserBidRS response = new CreateUserBidRS();
        String msg = "Bid for user creation with email '" + email + "' is successfully registered. Confirmation info will be send on provided email. Expiration: 1 day.";
        response.setMessage(msg);
        response.setBid(bid.getId());
        response.setBackLink(emailLink.toString());
        return response;
    }

    public CreateUserRS createUser(CreateUserRQConfirm request, String uuid, Principal principal) {
        UserCreationBid bid = (UserCreationBid)this.userCreationBidRepository.findOne((Serializable)((Object)uuid));
        BusinessRule.expect((Object)bid, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.INCORRECT_REQUEST, new Object[]{"Impossible to register user. UUID expired or already registered."});
        User user = this.userRepository.findOne(request.getLogin());
        BusinessRule.expect((Object)user, (Predicate)com.epam.ta.reportportal.commons.Predicates.isNull()).verify(ErrorType.USER_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"login='{}'", (Object[])new Object[]{request.getLogin()})});
        BusinessRule.expect((Object)request.getLogin(), Predicates.SPECIAL_CHARS_ONLY.negate()).verify(ErrorType.INCORRECT_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Username '{}' consists only of special characters", (Object[])new Object[]{request.getLogin()})});
        Project defaultProject = (Project)this.projectRepository.findOne((Serializable)((Object)bid.getDefaultProject()));
        BusinessRule.expect((Object)defaultProject, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{bid.getDefaultProject()});
        request.setDefaultProject(bid.getDefaultProject());
        String email = request.getEmail();
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)email), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{email});
        User email_user = this.userRepository.findByEmail(request.getEmail());
        BusinessRule.expect((Object)email_user, (Predicate)com.epam.ta.reportportal.commons.Predicates.isNull()).verify(ErrorType.USER_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"email='{}'", (Object[])new Object[]{request.getEmail()})});
        user = (User)((UserBuilder)this.userBuilder.get()).addCreateUserRQ(request).addUserRole(UserRole.USER).build();
        Optional projectRole = ProjectRole.forName((String)bid.getRole());
        BusinessRule.expect((Object)projectRole, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.ROLE_NOT_FOUND, new Object[]{bid.getRole()});
        Map projectUsers = defaultProject.getUsers();
        if (((ProjectRole)projectRole.get()).equals((Object)ProjectRole.CUSTOMER)) {
            projectUsers.put(user.getId(), Project.UserConfig.newOne().withProjectRole(ProjectRole.CUSTOMER).withProposedRole(ProjectRole.CUSTOMER));
        } else {
            projectUsers.put(user.getId(), Project.UserConfig.newOne().withProjectRole((ProjectRole)projectRole.get()).withProposedRole((ProjectRole)projectRole.get()));
        }
        defaultProject.setUsers(projectUsers);
        try {
            this.userRepository.save(user);
            this.projectRepository.addUsers(request.getDefaultProject(), projectUsers);
            Project personalProject = this.personalProjectService.generatePersonalProject(user);
            if (!defaultProject.getId().equals(personalProject.getId())) {
                this.projectRepository.save(personalProject);
            }
            this.userCreationBidRepository.delete((Serializable)((Object)uuid));
        }
        catch (DuplicateKeyException e) {
            BusinessRule.fail().withError(ErrorType.USER_ALREADY_EXISTS, new Object[]{Suppliers.formattedSupplier((String)"email='{}'", (Object[])new Object[]{request.getEmail()})});
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while User creating.", (Throwable)exp);
        }
        this.eventPublisher.publishEvent((Object)new UserCreatedEvent(user, user.getLogin()));
        CreateUserRS response = new CreateUserRS();
        response.setLogin(user.getLogin());
        return response;
    }

    public OperationCompletionRS createRestorePasswordBid(RestorePasswordRQ rq, String baseUrl) {
        EmailService emailService = this.emailServiceFactory.getDefaultEmailService(true);
        String email = EntityUtils.normalizeId((String)rq.getEmail());
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)email), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{email});
        User user = this.userRepository.findByEmail(email);
        BusinessRule.expect((Object)user, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{email});
        BusinessRule.expect((Object)user.getType(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to change password for external user"});
        RestorePasswordBid bid = (RestorePasswordBid)RestorePasswordBidConverter.TO_BID.apply(rq);
        this.restorePasswordBidRepository.save((Object)bid);
        try {
            emailService.sendRestorePasswordEmail("Password recovery", new String[]{rq.getEmail()}, baseUrl + "#login?reset=" + bid.getId(), user.getLogin());
        }
        catch (Exception e) {
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Unable to send email for bid '{}'.", (Object[])new Object[]{bid.getId()})});
        }
        return new OperationCompletionRS("Email has been sent");
    }

    public OperationCompletionRS resetPassword(ResetPasswordRQ rq) {
        RestorePasswordBid bid = (RestorePasswordBid)this.restorePasswordBidRepository.findOne((Serializable)((Object)rq.getUuid()));
        BusinessRule.expect((Object)bid, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.ACCESS_DENIED, new Object[]{"The password change link is no longer valid."});
        String email = bid.getEmail();
        BusinessRule.expect((Object)UserUtils.isEmailValid((String)email), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{email});
        User byEmail = this.userRepository.findByEmail(email);
        BusinessRule.expect((Object)byEmail, (Predicate)com.epam.ta.reportportal.commons.Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[0]);
        BusinessRule.expect((Object)byEmail.getType(), (Predicate)com.epam.ta.reportportal.commons.Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Unable to change password for external user"});
        byEmail.setPassword(HASH_FUNCTION.hashString((CharSequence)rq.getPassword(), Charsets.UTF_8).toString());
        this.userRepository.save(byEmail);
        this.restorePasswordBidRepository.delete((Serializable)((Object)rq.getUuid()));
        OperationCompletionRS rs = new OperationCompletionRS();
        rs.setResultMessage("Password has been changed");
        return rs;
    }

    public YesNoRS isResetPasswordBidExist(String id) {
        RestorePasswordBid bid = (RestorePasswordBid)this.restorePasswordBidRepository.findOne((Serializable)((Object)id));
        return new YesNoRS(null != bid);
    }
}

