/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.WidgetContentProvider;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.database.search.FilterConditionUtils;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="OldBuildFilterStrategy")
public class GeneralFilterStrategy
implements BuildFilterStrategy {
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private WidgetContentProvider widgetContentProvider;
    private final FilterCondition modeCondition = new FilterCondition(Condition.EQUALS, false, Mode.DEFAULT.toString(), "mode");

    public Map<String, List<ChartObject>> buildFilterAndLoadContent(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        Filter searchFilter = userFilter.getFilter();
        if (searchFilter.getTarget().getSimpleName().equalsIgnoreCase(TestItem.class.getSimpleName()) && null != contentOptions.getMetadataFields() && contentOptions.getMetadataFields().contains("number")) {
            contentOptions.getMetadataFields().remove("number");
        }
        searchFilter.addConditions((Collection)this.getAdditionalConditions(searchFilter.getTarget(), projectName));
        return this.widgetContentProvider.getChartContent(searchFilter, userFilter.getSelectionOptions(), contentOptions);
    }

    private Set<FilterCondition> getAdditionalConditions(Class<?> type, String projectName) {
        HashSet<FilterCondition> result = new HashSet<FilterCondition>();
        if (TestItem.class.equals(type)) {
            result.add(this.getConditionForTestItem(projectName));
        } else if (type.equals(Launch.class)) {
            result.add(new FilterCondition(Condition.EQUALS, false, projectName, "project"));
            result.add(FilterConditionUtils.LAUNCH_NOT_IN_PROGRESS());
            result.add(this.modeCondition);
        } else {
            throw new ReportPortalException("Unable load content per field");
        }
        return result;
    }

    private FilterCondition getConditionForTestItem(String projectName) {
        Filter filter = new Filter(Launch.class, Condition.EQUALS, false, projectName, "project");
        filter.addCondition(this.modeCondition);
        List launches = this.launchRepository.findIdsByFilter(filter);
        String value = launches.stream().map(Launch::getId).collect(Collectors.joining(","));
        return new FilterCondition(Condition.IN, false, value, "launch");
    }
}

