/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.database.entity.filter.SelectionOptions;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WidgetContentProvider {
    @Autowired
    private CriteriaMapFactory criteriaMapFactory;
    @Autowired
    @Qualifier(value="contentLoader")
    private Map<GadgetTypes, IContentLoadingStrategy> contentLoader;

    public Map<String, List<ChartObject>> getChartContent(Filter filter, SelectionOptions selectionOptions, ContentOptions options) {
        Sort sort;
        boolean revertResult = false;
        Class type = filter.getTarget();
        CriteriaMap criteriaMap = this.criteriaMapFactory.getCriteriaMap(type);
        List contentFields = WidgetContentProvider.transformToDBStyle((CriteriaMap)criteriaMap, (List)options.getContentFields());
        List metaDataFields = WidgetContentProvider.transformToDBStyle((CriteriaMap)criteriaMap, (List)options.getMetadataFields());
        boolean isAscSort = selectionOptions.isAsc();
        String sortingColumnName = selectionOptions.getSortingColumnName();
        if ("start_time".equalsIgnoreCase(sortingColumnName) && isAscSort) {
            sort = new Sort(Sort.Direction.DESC, new String[]{criteriaMap.getCriteriaHolder(sortingColumnName).getQueryCriteria()});
            revertResult = true;
        } else {
            sort = new Sort(isAscSort ? Sort.Direction.ASC : Sort.Direction.DESC, new String[]{criteriaMap.getCriteriaHolder(sortingColumnName).getQueryCriteria()});
        }
        IContentLoadingStrategy loadingStrategy = (IContentLoadingStrategy)this.contentLoader.get(GadgetTypes.findByName((String)options.getGadgetType()).get());
        BusinessRule.expect((Object)loadingStrategy, (Predicate)Predicates.notNull()).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{Suppliers.formattedSupplier((String)"Unknown gadget type: '{}'.", (Object[])new Object[]{options.getGadgetType()})});
        Map widgetOptions = null == options.getWidgetOptions() ? new HashMap() : options.getWidgetOptions();
        Map result = loadingStrategy.loadContent(filter, sort, options.getItemsCount(), contentFields, metaDataFields, widgetOptions);
        if (null != options.getContentFields()) {
            result = this.transformToFilterStyle(criteriaMap, result, options.getContentFields());
            result = this.transformNamesForUI(result);
        }
        if (!revertResult || options.getGadgetType().equalsIgnoreCase(GadgetTypes.CASES_TREND.getType())) {
            result = this.mapRevert(result);
        }
        return result;
    }

    private Map<String, List<ChartObject>> transformToFilterStyle(CriteriaMap<?> criteriaMap, Map<String, List<ChartObject>> input, List<String> chartFields) {
        LinkedHashMap<String, List<ChartObject>> result = new LinkedHashMap<String, List<ChartObject>>();
        for (Map.Entry<String, List<ChartObject>> entry : input.entrySet()) {
            boolean isConverted = false;
            List<ChartObject> data = entry.getValue();
            for (String field : chartFields) {
                String queryCriteria = criteriaMap.getCriteriaHolder(field).getQueryCriteria();
                if (!queryCriteria.equals(entry.getKey())) continue;
                result.put(criteriaMap.getCriteriaHolder(queryCriteria).getFilterCriteria(), data);
                isConverted = true;
                break;
            }
            if (isConverted) continue;
            result.put(entry.getKey(), data);
        }
        return result;
    }

    private Map<String, List<ChartObject>> transformNamesForUI(Map<String, List<ChartObject>> input) {
        for (Map.Entry<String, List<ChartObject>> entry : input.entrySet()) {
            for (ChartObject exist : entry.getValue()) {
                HashMap<String, String> values = new HashMap<String, String>();
                for (String key : exist.getValues().keySet()) {
                    String keyValue = (String)exist.getValues().get(key);
                    values.put(key.replaceAll("\\.", "\\$"), keyValue);
                }
                exist.setValues(values);
            }
        }
        return input;
    }

    public static List<String> transformToDBStyle(CriteriaMap<?> criteriaMap, List<String> chartFields) {
        if (chartFields == null) {
            return new ArrayList<String>();
        }
        return chartFields.stream().map(it -> criteriaMap.getCriteriaHolder(it).getQueryCriteria()).collect(Collectors.toList());
    }

    private Map<String, List<ChartObject>> mapRevert(Map<String, List<ChartObject>> input) {
        LinkedHashMap<String, List<ChartObject>> result = new LinkedHashMap<String, List<ChartObject>>();
        for (Map.Entry<String, List<ChartObject>> entry : input.entrySet()) {
            ArrayList newOrder = Lists.newArrayList();
            List<ChartObject> data = entry.getValue();
            for (int i = data.size() - 1; i >= 0; --i) {
                newOrder.add(data.get(i));
            }
            result.put(entry.getKey(), newOrder);
        }
        return result;
    }
}

