/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.acl.SharingService;
import com.epam.ta.reportportal.core.widget.ICreateWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.core.widget.impl.WidgetUtils;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateWidgetHandler
implements ICreateWidgetHandler {
    private WidgetRepository widgetRepository;
    private Provider<WidgetBuilder> widgetBuilder;
    private UserFilterRepository filterRepository;
    private CriteriaMapFactory criteriaMapFactory;
    private SharingService sharingService;

    @Autowired
    public void setWidgetRepository(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Autowired
    public void setWidgetBuilder(Provider<WidgetBuilder> widgetBuilder) {
        this.widgetBuilder = widgetBuilder;
    }

    @Autowired
    public void setUserFilterRepository(UserFilterRepository userFilterRepository) {
        this.filterRepository = userFilterRepository;
    }

    @Autowired
    public void setCriteriaMapFactory(CriteriaMapFactory criteriaMapFactory) {
        this.criteriaMapFactory = criteriaMapFactory;
    }

    @Autowired
    public void setSharingService(SharingService sharingService) {
        this.sharingService = sharingService;
    }

    public EntryCreatedRS createWidget(WidgetRQ createWidgetRQ, String projectName, String userName) {
        GadgetTypes gadget;
        List widgetList = this.widgetRepository.findByProjectAndUser(projectName, userName);
        WidgetUtils.checkUniqueName((String)createWidgetRQ.getName(), (List)widgetList);
        UserFilter filter = this.filterRepository.findOneLoadACL(userName, createWidgetRQ.getApplyingFilter(), projectName);
        WidgetUtils.validateWidgetDataType((String)createWidgetRQ.getContentParameters().getType(), (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        WidgetUtils.validateGadgetType((String)createWidgetRQ.getContentParameters().getGadget(), (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        if (GadgetTypes.findByName((String)createWidgetRQ.getContentParameters().getGadget()).get() != GadgetTypes.ACTIVITY && GadgetTypes.findByName((String)createWidgetRQ.getContentParameters().getGadget()).get() != GadgetTypes.MOST_FAILED_TEST_CASES && GadgetTypes.findByName((String)createWidgetRQ.getContentParameters().getGadget()).get() != GadgetTypes.PASSING_RATE_PER_LAUNCH) {
            this.checkApplyingFilter(filter, createWidgetRQ.getApplyingFilter(), userName);
        }
        if (null != createWidgetRQ.getContentParameters().getMetadataFields() && (null == filter || filter.getFilter().getTarget().equals(TestItem.class)) && createWidgetRQ.getContentParameters().getMetadataFields().contains("number")) {
            createWidgetRQ.getContentParameters().getMetadataFields().remove("number");
        }
        if (null != createWidgetRQ.getContentParameters().getContentFields() && (null == filter || filter.getFilter().getTarget().equals(TestItem.class))) {
            if (createWidgetRQ.getContentParameters().getContentFields().contains("number")) {
                createWidgetRQ.getContentParameters().getContentFields().remove("number");
            }
            if (createWidgetRQ.getContentParameters().getContentFields().contains("user")) {
                createWidgetRQ.getContentParameters().getContentFields().remove("user");
            }
        }
        Class filterTarget = (gadget = (GadgetTypes)GadgetTypes.findByName((String)createWidgetRQ.getContentParameters().getGadget()).get()) == GadgetTypes.UNIQUE_BUG_TABLE ? TestItem.class : (gadget == GadgetTypes.ACTIVITY ? Activity.class : (gadget == GadgetTypes.MOST_FAILED_TEST_CASES ? TestItem.class : (gadget == GadgetTypes.PASSING_RATE_PER_LAUNCH ? Launch.class : filter.getFilter().getTarget())));
        CriteriaMap criteriaMap = this.criteriaMapFactory.getCriteriaMap(filterTarget);
        if (null != createWidgetRQ.getContentParameters().getContentFields()) {
            WidgetUtils.validateFields((Iterable)createWidgetRQ.getContentParameters().getContentFields(), (CriteriaMap)criteriaMap, (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        }
        if (null != createWidgetRQ.getContentParameters().getMetadataFields()) {
            WidgetUtils.validateFields((Iterable)createWidgetRQ.getContentParameters().getMetadataFields(), (CriteriaMap)criteriaMap, (ErrorType)ErrorType.BAD_SAVE_WIDGET_REQUEST);
        }
        Widget widget = (Widget)((WidgetBuilder)this.widgetBuilder.get()).addWidgetRQ(createWidgetRQ).addFilter(createWidgetRQ.getApplyingFilter()).addProject(projectName).addSharing(userName, projectName, createWidgetRQ.getDescription(), createWidgetRQ.getShare() == null ? false : createWidgetRQ.getShare()).build();
        this.shareIfRequired(createWidgetRQ.getShare(), widget, userName, projectName, filter);
        this.widgetRepository.save((Object)widget);
        return new EntryCreatedRS(widget.getId());
    }

    private void shareIfRequired(Boolean isShare, Widget widget, String userName, String projectName, UserFilter filter) {
        if (isShare != null) {
            if (null != filter) {
                AclUtils.isPossibleToRead((Acl)filter.getAcl(), (String)userName, (String)projectName);
            }
            this.sharingService.modifySharing((List)Lists.newArrayList((Object[])new Widget[]{widget}), userName, projectName, isShare.booleanValue());
        }
    }

    private void checkApplyingFilter(UserFilter filter, String filterID, String userName) {
        BusinessRule.expect((Object)filter, (Predicate)Predicates.notNull()).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{filterID, userName});
        BusinessRule.expect((Object)filter.isLink(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.UNABLE_TO_CREATE_WIDGET, new Object[]{"Cannot create widget based on a link."});
    }
}

