/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.widget.IGetWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.ws.converter.WidgetResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.epam.ta.reportportal.ws.model.widget.WidgetResource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class GetWidgetHandler
implements IGetWidgetHandler {
    private WidgetRepository widgetRepository;
    private WidgetResourceAssembler resourceAssembler;
    private UserFilterRepository userFilterRepository;
    private Map<GadgetTypes, BuildFilterStrategy> buildFilterStrategy;

    @Autowired
    public void setWidgetRepository(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    @Autowired
    public void setWidgetResourceAssembler(WidgetResourceAssembler widgetResourceAssembler) {
        this.resourceAssembler = widgetResourceAssembler;
    }

    @Autowired
    public void setUserFilterRepository(UserFilterRepository userFilterRepository) {
        this.userFilterRepository = userFilterRepository;
    }

    @Autowired
    @Qualifier(value="buildFilterStrategy")
    public void setBuildFilterStrategy(Map<GadgetTypes, BuildFilterStrategy> buildFilterStrategy) {
        this.buildFilterStrategy = buildFilterStrategy;
    }

    public WidgetResource getWidget(String widgetId, String userName, String project) {
        WidgetResource widgetResource;
        Widget widget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widgetId));
        BusinessRule.expect((Object)widget, (Predicate)Predicates.notNull()).verify(ErrorType.WIDGET_NOT_FOUND, new Object[]{widgetId});
        BusinessRule.expect((Object)widget.getProjectName(), (Predicate)Predicates.equalTo((Object)project)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        if (!AclUtils.isPossibleToReadResource((Acl)widget.getAcl(), (String)userName, (String)project)) {
            Widget emptyModel = new Widget();
            emptyModel.setName(widget.getName());
            emptyModel.setOwner(widget.getAcl().getOwnerUserId());
            widgetResource = this.resourceAssembler.toResource(emptyModel);
        } else {
            widgetResource = this.resourceAssembler.toResource(widget);
            Optional userFilter = this.findUserFilter(widget.getApplyingFilterId());
            GadgetTypes gadgetType = (GadgetTypes)GadgetTypes.findByName((String)widget.getContentOptions().getGadgetType()).get();
            if (!this.isRequireUserFilter(gadgetType, userFilter) || this.isFilterUnShared(userName, project, userFilter)) {
                widgetResource.setContent(new HashMap());
            } else {
                widgetResource.setContent(this.loadContentByFilterType(userFilter, project, widget.getContentOptions()));
            }
        }
        return widgetResource;
    }

    public Map<String, SharedEntity> getSharedWidgetNames(String userName, String projectName) {
        List widgets = this.widgetRepository.findSharedEntities(userName, projectName, Arrays.asList("_id", "name", "acl.ownerUserId"), Shareable.NAME_OWNER_SORT);
        return this.toMap(widgets);
    }

    public List<WidgetResource> getSharedWidgetsList(String userName, String projectName) {
        List widgets = this.widgetRepository.findSharedEntities(userName, projectName, Arrays.asList("_id", "name", "description", "acl.ownerUserId", "contentOptions.gadgetType", "contentOptions.contentFields"), Shareable.NAME_OWNER_SORT);
        return this.resourceAssembler.toResources((Iterable)widgets);
    }

    public List<String> getWidgetNames(String projectName, String userName) {
        return this.widgetRepository.findByProjectAndUser(projectName, userName).stream().map(Widget::getName).collect(Collectors.toList());
    }

    private Map<String, SharedEntity> toMap(List<Widget> widgets) {
        LinkedHashMap<String, SharedEntity> result = new LinkedHashMap<String, SharedEntity>();
        for (Widget widget : widgets) {
            SharedEntity sharedEntity = new SharedEntity();
            sharedEntity.setName(widget.getName());
            if (null != widget.getAcl()) {
                sharedEntity.setOwner(widget.getAcl().getOwnerUserId());
            }
            result.put(widget.getId(), sharedEntity);
        }
        return result;
    }

    private boolean isRequireUserFilter(GadgetTypes gadgetType, Optional<UserFilter> userFilter) {
        return userFilter.isPresent() || gadgetType == GadgetTypes.ACTIVITY || gadgetType == GadgetTypes.MOST_FAILED_TEST_CASES || gadgetType == GadgetTypes.PASSING_RATE_PER_LAUNCH;
    }

    private boolean isFilterUnShared(String userName, String project, Optional<UserFilter> userFilter) {
        return userFilter.isPresent() && !AclUtils.isPossibleToReadResource((Acl)userFilter.get().getAcl(), (String)userName, (String)project);
    }

    Map<String, List<ChartObject>> loadContentByFilterType(Optional<UserFilter> userFilter, String projectName, ContentOptions contentOptions) {
        Map<String, List<Object>> content;
        if (userFilter.isPresent() && Log.class.equals((Object)userFilter.get().getFilter().getTarget())) {
            content = new HashMap<String, List<ChartObject>>();
        } else {
            BuildFilterStrategy filterStrategy = (BuildFilterStrategy)this.buildFilterStrategy.get(GadgetTypes.findByName((String)contentOptions.getGadgetType()).get());
            BusinessRule.expect((Object)filterStrategy, (Predicate)Predicates.notNull()).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{Suppliers.formattedSupplier((String)"Unknown gadget type: '{}'.", (Object[])new Object[]{contentOptions.getGadgetType()})});
            content = filterStrategy.buildFilterAndLoadContent((UserFilter)userFilter.orElse(null), contentOptions, projectName);
        }
        return content;
    }

    private Optional<UserFilter> findUserFilter(String filterId) {
        return Optional.ofNullable(filterId == null ? null : (UserFilter)this.userFilterRepository.findOne((Serializable)((Object)filterId)));
    }
}

