/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demo_data;

import com.epam.ta.reportportal.core.statistics.StatisticsFacade;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.database.dao.LaunchMetaInfoRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.StatisticsCalculationStrategy;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.statistics.Statistics;
import com.epam.ta.reportportal.demo_data.ContentUtils;
import com.epam.ta.reportportal.demo_data.DemoLogsService;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.SplittableRandom;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DemoDataCommonService {
    static final String NAME = "Demo Api Tests";
    static final int STORY_PROBABILITY = 30;
    protected SplittableRandom random = new SplittableRandom();
    static final int CONTENT_PROBABILITY = 60;
    private static final int TAGS_COUNT = 3;
    @Autowired
    DemoLogsService logDemoDataService;
    @Autowired
    protected LaunchRepository launchRepository;
    @Autowired
    protected ObjectMapper objectMapper;
    @Autowired
    protected TestItemRepository testItemRepository;
    @Autowired
    protected StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private LaunchMetaInfoRepository launchCounter;

    String startLaunch(String name, int i, String project, String user) {
        Launch launch = new Launch();
        launch.setName(name);
        launch.setStartTime(new Date());
        launch.setTags((Set)ImmutableSet.builder().addAll(Arrays.asList("desktop", "demo", "build:3.0.1." + (i + 1))).build());
        launch.setDescription(ContentUtils.getLaunchDescription());
        launch.setStatus(Status.IN_PROGRESS);
        launch.setUserRef(user);
        launch.setProjectRef(project);
        launch.setNumber(Long.valueOf(this.launchCounter.getLaunchNumber(name, project)));
        launch.setMode(Mode.DEFAULT);
        return ((Launch)this.launchRepository.save((Object)launch)).getId();
    }

    void finishLaunch(String launchId) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        launch.setEndTime(new Date());
        launch.setStatus(StatisticsHelper.getStatusFromStatistics((Statistics)launch.getStatistics()));
        this.launchRepository.save((Object)launch);
    }

    TestItem startRootItem(String rootItemName, String launchId, TestItemType type) {
        TestItem testItem = new TestItem();
        testItem.setLaunchRef(launchId);
        if (type.sameLevel(TestItemType.SUITE) && ContentUtils.getWithProbability((int)60)) {
            testItem.setTags(ContentUtils.getTagsInRange((int)3));
            testItem.setItemDescription(ContentUtils.getSuiteDescription());
        }
        testItem.setStartTime(new Date());
        testItem.setName(rootItemName);
        testItem.setHasChilds(true);
        testItem.setStatus(Status.IN_PROGRESS);
        testItem.setType(type);
        return (TestItem)this.testItemRepository.save((Object)testItem);
    }

    void finishRootItem(String rootItemId) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)rootItemId));
        testItem.setEndTime(new Date());
        testItem.setStatus(StatisticsHelper.getStatusFromStatistics((Statistics)testItem.getStatistics()));
        this.testItemRepository.save((Object)testItem);
    }

    TestItem startTestItem(TestItem rootItemId, String launchId, String name, TestItemType type) {
        TestItem testItem = new TestItem();
        if (ContentUtils.getWithProbability((int)60)) {
            if (this.hasChildren(type)) {
                testItem.setTags(ContentUtils.getTagsInRange((int)3));
                testItem.setItemDescription(ContentUtils.getTestDescription());
            } else {
                testItem.setTags(ContentUtils.getTagsInRange((int)3));
                testItem.setItemDescription(ContentUtils.getStepDescription());
            }
        }
        testItem.setLaunchRef(launchId);
        testItem.setStartTime(new Date());
        testItem.setName(name);
        testItem.setParent(rootItemId.getId());
        testItem.setHasChilds(this.hasChildren(type));
        testItem.setStatus(Status.IN_PROGRESS);
        testItem.setType(type);
        testItem.getPath().addAll(rootItemId.getPath());
        testItem.getPath().add(rootItemId.getId());
        return (TestItem)this.testItemRepository.save((Object)testItem);
    }

    void finishTestItem(String testItemId, String status, StatisticsCalculationStrategy statsStrategy) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItemId));
        StatisticsFacade statisticsFacade = this.statisticsFacadeFactory.getStatisticsFacade(statsStrategy);
        if ("FAILED".equals(status) && statisticsFacade.awareIssue(testItem)) {
            testItem.setIssue(this.issueType());
        }
        testItem.setStatus((Status)Status.fromValue((String)status).get());
        testItem.setEndTime(new Date());
        this.testItemRepository.save((Object)testItem);
        statisticsFacade.updateExecutionStatistics(testItem);
        if (null != testItem.getIssue()) {
            statisticsFacade.updateIssueStatistics(testItem);
        }
    }

    String status() {
        int STATUS_PROBABILITY = 15;
        if (ContentUtils.getWithProbability((int)STATUS_PROBABILITY)) {
            return Status.SKIPPED.name();
        }
        if (ContentUtils.getWithProbability((int)(2 * STATUS_PROBABILITY))) {
            return Status.FAILED.name();
        }
        return Status.PASSED.name();
    }

    boolean hasChildren(TestItemType testItemType) {
        return testItemType != TestItemType.STEP && testItemType != TestItemType.BEFORE_CLASS && testItemType != TestItemType.BEFORE_METHOD && testItemType != TestItemType.AFTER_CLASS && testItemType != TestItemType.AFTER_METHOD;
    }

    TestItemIssue issueType() {
        int ISSUE_PROBABILITY = 25;
        if (ContentUtils.getWithProbability((int)ISSUE_PROBABILITY)) {
            return ContentUtils.getProductBug();
        }
        if (ContentUtils.getWithProbability((int)ISSUE_PROBABILITY)) {
            return ContentUtils.getAutomationBug();
        }
        if (ContentUtils.getWithProbability((int)ISSUE_PROBABILITY)) {
            return ContentUtils.getSystemIssue();
        }
        return ContentUtils.getInvestigate();
    }
}

