/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demo_data;

import com.epam.ta.reportportal.database.entity.StatisticsCalculationStrategy;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import com.epam.ta.reportportal.demo_data.ContentUtils;
import com.epam.ta.reportportal.demo_data.DemoDataCommonService;
import com.epam.ta.reportportal.demo_data.DemoDataFacade;
import com.epam.ta.reportportal.demo_data.DemoDataRq;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class StepBasedDemoDataFacade
extends DemoDataCommonService
implements DemoDataFacade {
    private static final StatisticsCalculationStrategy strategy = StatisticsCalculationStrategy.STEP_BASED;
    @Value(value="classpath:demo/demo_data.json")
    private Resource resource;

    public List<String> generateDemoLaunches(DemoDataRq demoDataRq, String user, String projectName) {
        Map suites;
        try {
            suites = (Map)this.objectMapper.readValue(this.resource.getURL(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            throw new ReportPortalException("Unable to load suites description. " + e.getMessage(), (Throwable)e);
        }
        return this.generateLaunches(demoDataRq, suites, user, projectName, strategy);
    }

    private List<String> generateLaunches(DemoDataRq rq, Map<String, Map<String, List<String>>> suitesStructure, String user, String project, StatisticsCalculationStrategy statsStrategy) {
        return IntStream.range(0, rq.getLaunchesQuantity()).mapToObj(launchRunCount -> {
            String launchId = this.startLaunch("Demo Api Tests_" + rq.getPostfix(), launchRunCount, project, user);
            this.generateSuites(suitesStructure, launchRunCount, launchId, statsStrategy, project);
            this.finishLaunch(launchId);
            return launchId;
        }).collect(Collectors.toList());
    }

    private List<String> generateSuites(Map<String, Map<String, List<String>>> suitesStructure, int launchRunCount, String launchId, StatisticsCalculationStrategy statsStrategy, String project) {
        return suitesStructure.entrySet().stream().limit(launchRunCount + 1).map(suites -> {
            TestItem suiteItem = this.startRootItem((String)suites.getKey(), launchId, TestItemType.SUITE);
            ((Map)suites.getValue()).entrySet().forEach(tests -> {
                TestItem testItem = this.startTestItem(suiteItem, launchId, (String)tests.getKey(), TestItemType.TEST);
                String beforeClassStatus = "";
                boolean isGenerateClass = ContentUtils.getWithProbability((int)30);
                if (isGenerateClass) {
                    TestItem beforeClass = this.startTestItem(testItem, launchId, "beforeClass", TestItemType.BEFORE_CLASS);
                    beforeClassStatus = this.status();
                    this.finishTestItem(beforeClass.getId(), beforeClassStatus, statsStrategy);
                }
                boolean isGenerateBeforeMethod = ContentUtils.getWithProbability((int)30);
                boolean isGenerateAfterMethod = ContentUtils.getWithProbability((int)30);
                ((List)tests.getValue()).stream().limit(launchRunCount + 1).forEach(name -> {
                    if (isGenerateBeforeMethod) {
                        this.finishTestItem(this.startTestItem(testItem, launchId, "beforeMethod", TestItemType.BEFORE_METHOD).getId(), this.status(), statsStrategy);
                    }
                    TestItem stepId = this.startTestItem(testItem, launchId, name, TestItemType.STEP);
                    String status = this.status();
                    this.logDemoDataService.generateDemoLogs(stepId.getId(), status, project);
                    this.finishTestItem(stepId.getId(), status, statsStrategy);
                    if (isGenerateAfterMethod) {
                        this.finishTestItem(this.startTestItem(testItem, launchId, "afterMethod", TestItemType.AFTER_METHOD).getId(), this.status(), statsStrategy);
                    }
                });
                if (isGenerateClass) {
                    TestItem afterClass = this.startTestItem(testItem, launchId, "afterClass", TestItemType.AFTER_CLASS);
                    this.finishTestItem(afterClass.getId(), this.status(), statsStrategy);
                }
                this.finishTestItem(testItem.getId(), !beforeClassStatus.isEmpty() ? beforeClassStatus : "FAILED", statsStrategy);
            });
            this.finishRootItem(suiteItem.getId());
            return suiteItem.getId();
        }).collect(Collectors.toList());
    }
}

