/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.events.WidgetUpdatedEvent;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class WidgetActivityEventHandler {
    public static final String SHARE = "share";
    public static final String UNSHARE = "unshare";
    @Autowired
    private ActivityRepository activityRepository;
    @Autowired
    private Provider<ActivityBuilder> activityBuilder;

    @EventListener
    public void onWidgetUpdated(WidgetUpdatedEvent event) {
        Widget widget = (Widget)event.getBefore();
        WidgetRQ widgetRQ = event.getWidgetRQ();
        if (null != widgetRQ.getShare() && widget != null) {
            boolean isShared;
            boolean bl = isShared = !widget.getAcl().getEntries().isEmpty();
            if (!widgetRQ.getShare().equals(isShared)) {
                Activity activityLog = (Activity)((ActivityBuilder)this.activityBuilder.get()).addProjectRef(widget.getProjectName()).addObjectType("widget").addUserRef(event.getUpdatedBy()).addActionType(widgetRQ.getShare() != false ? SHARE : UNSHARE).addLoggedObjectRef(widget.getId()).addObjectName(widgetRQ.getName()).build();
                this.activityRepository.save((Object)activityLog);
            }
        }
    }
}

