/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.project.KeepLogsDelay;
import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class CleanLogsJob
implements Runnable {
    @Autowired
    private LogRepository logRepo;
    @Autowired
    private LaunchRepository launchRepo;
    @Autowired
    private TestItemRepository testItemRepo;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private ActivityRepository activityRepository;

    @Override
    @Scheduled(cron="${com.ta.reportportal.job.clean.logs.cron}")
    public void run() {
        try (Stream stream = this.projectRepository.streamAllIdsAndConfiguration();){
            stream.forEach(project -> {
                Duration period = Duration.ofDays(KeepLogsDelay.findByName((String)project.getConfiguration().getKeepLogs()).getDays());
                this.activityRepository.deleteModifiedLaterAgo(project.getId(), period);
                this.removeOutdatedLogs(project.getId(), period);
            });
        }
    }

    private void removeOutdatedLogs(String projectId, Duration period) {
        try (Stream launchStream = this.launchRepo.streamIdsByProject(projectId);){
            launchStream.forEach(launch -> {
                try (Stream testItemStream = this.testItemRepo.streamIdsByLaunch(launch.getId());){
                    this.logRepo.deleteByPeriodAndItemsRef(period, testItemStream.map(TestItem::getId).collect(Collectors.toList()));
                }
            });
        }
    }
}

