/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.dao.FailReferenceResourceRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.project.InterruptionJobDelay;
import java.io.Serializable;
import java.time.Duration;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class InterruptBrokenLaunchesJob
implements Runnable {
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private FailReferenceResourceRepository issuesRepository;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private ProjectRepository projectRepository;

    @Override
    @Scheduled(cron="${com.ta.reportportal.job.interrupt.broken.launches.cron}")
    public void run() {
        try (Stream projects = this.projectRepository.streamAllIdsAndConfiguration();){
            projects.forEach(project -> {
                Duration maxDuration = Duration.ofHours(InterruptionJobDelay.findByName((String)project.getConfiguration().getInterruptJobTime()).getPeriod());
                this.launchRepository.findModifiedLaterAgo(maxDuration, Status.IN_PROGRESS, project.getId()).forEach(launch -> {
                    if (!this.launchRepository.hasItems(launch, Status.IN_PROGRESS)) {
                        this.interruptLaunch(launch);
                    } else if (!this.testItemRepository.hasTestItemsAddedLately(maxDuration, launch, Status.IN_PROGRESS)) {
                        List items = this.testItemRepository.findModifiedLaterAgo(maxDuration, Status.IN_PROGRESS, launch);
                        if (this.testItemRepository.hasLogs((Iterable)items)) {
                            boolean isLaunchBroken = true;
                            for (TestItem item : items) {
                                if (!this.logRepository.hasLogsAddedLately(maxDuration, item)) continue;
                                isLaunchBroken = false;
                                break;
                            }
                            if (isLaunchBroken) {
                                this.interruptItems(this.testItemRepository.findInStatusItems(Status.IN_PROGRESS.name(), launch.getId()), launch);
                            }
                        } else {
                            this.interruptItems(this.testItemRepository.findInStatusItems(Status.IN_PROGRESS.name(), launch.getId()), launch);
                        }
                    }
                });
            });
        }
    }

    private void interruptLaunch(Launch launch) {
        launch.setStatus(Status.INTERRUPTED);
        launch.setEndTime(Calendar.getInstance().getTime());
        this.launchRepository.save((Object)launch);
        this.clearIssueReferences(launch.getId());
    }

    private void interruptItems(List<TestItem> testItems, Launch launch) {
        if (testItems.isEmpty()) {
            return;
        }
        testItems.forEach(item -> this.interruptItem(item, launch));
        Launch launchReloaded = (Launch)this.launchRepository.findOne((Serializable)((Object)launch.getId()));
        launchReloaded.setStatus(Status.INTERRUPTED);
        launchReloaded.setEndTime(Calendar.getInstance().getTime());
        this.launchRepository.save((Object)launchReloaded);
        this.clearIssueReferences(launch.getId());
    }

    private void clearIssueReferences(String launchId) {
        this.issuesRepository.deleteAllIssuesForLaunch(launchId);
    }

    private void interruptItem(TestItem item, Launch launch) {
        if (!Status.INTERRUPTED.equals((Object)item.getStatus())) {
            Project project;
            item.setStatus(Status.INTERRUPTED);
            item.setEndTime(Calendar.getInstance().getTime());
            item = (TestItem)this.testItemRepository.save((Object)item);
            if (!item.hasChilds() && null != (item = this.statisticsFacadeFactory.getStatisticsFacade((project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()))).getConfiguration().getStatisticsCalculationStrategy()).updateExecutionStatistics(item)).getIssue()) {
                item = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).updateIssueStatistics(item);
            }
            if (null != item.getParent()) {
                this.interruptItem((TestItem)this.testItemRepository.findOne((Serializable)((Object)item.getParent())), launch);
            }
        }
    }
}

