/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.activity.IActivityHandler;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.controller.IActivityController;
import com.epam.ta.reportportal.ws.model.ActivityResource;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/{projectName}/activity"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class ActivityController
implements IActivityController {
    @Autowired
    private IActivityHandler activityHandler;

    @RequestMapping(value={"/{activityId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiIgnore
    public ActivityResource getActivity(@PathVariable String projectName, @PathVariable String activityId, Principal principal) {
        return this.activityHandler.getActivity(EntityUtils.normalizeId((String)projectName), activityId);
    }

    @RequestMapping(value={"/item/{itemId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Get activities by filter")
    public List<ActivityResource> getTestItemActivities(@PathVariable String projectName, @PathVariable String itemId, @FilterFor(value=Activity.class) Filter filter, @SortFor(value=Activity.class) Pageable pageable, Principal principal) {
        return this.activityHandler.getItemActivities(EntityUtils.normalizeId((String)projectName), itemId, filter, pageable);
    }
}

