/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.externalsystem.handler.ICreateExternalSystemHandler;
import com.epam.ta.reportportal.core.externalsystem.handler.ICreateTicketHandler;
import com.epam.ta.reportportal.core.externalsystem.handler.IDeleteExternalSystemHandler;
import com.epam.ta.reportportal.core.externalsystem.handler.IGetExternalSystemHandler;
import com.epam.ta.reportportal.core.externalsystem.handler.IGetTicketHandler;
import com.epam.ta.reportportal.core.externalsystem.handler.IUpdateExternalSystemHandler;
import com.epam.ta.reportportal.ws.controller.IExternalSystemController;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.externalsystem.CreateExternalSystemRQ;
import com.epam.ta.reportportal.ws.model.externalsystem.ExternalSystemResource;
import com.epam.ta.reportportal.ws.model.externalsystem.PostFormField;
import com.epam.ta.reportportal.ws.model.externalsystem.PostTicketRQ;
import com.epam.ta.reportportal.ws.model.externalsystem.Ticket;
import com.epam.ta.reportportal.ws.model.externalsystem.UpdateExternalSystemRQ;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/{projectName}/external-system"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class ExternalSystemController
implements IExternalSystemController {
    @Autowired
    private ICreateTicketHandler createTicketHandler;
    @Autowired
    private IGetTicketHandler getTicketHandler;
    @Autowired
    private ICreateExternalSystemHandler createExternalSystemHandler;
    @Autowired
    private IDeleteExternalSystemHandler deleteExternalSystemHandler;
    @Autowired
    private IUpdateExternalSystemHandler updateExternalSystemHandler;
    @Autowired
    private IGetExternalSystemHandler getExternalSystemHandler;

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Register external system instance")
    public EntryCreatedRS createExternalSystemInstance(@Validated @RequestBody CreateExternalSystemRQ createRQ, @PathVariable String projectName, Principal principal) {
        return this.createExternalSystemHandler.createExternalSystem(createRQ, EntityUtils.normalizeId((String)projectName), principal.getName());
    }

    @RequestMapping(value={"/{systemId}"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get registered external system instance")
    public ExternalSystemResource getExternalSystem(@PathVariable String projectName, @PathVariable String systemId, Principal principal) {
        return this.getExternalSystemHandler.getExternalSystem(EntityUtils.normalizeId((String)projectName), systemId);
    }

    @RequestMapping(value={"/{systemId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete registered external system instance")
    public OperationCompletionRS deleteExternalSystem(@PathVariable String projectName, @PathVariable String systemId, Principal principal) {
        return this.deleteExternalSystemHandler.deleteExternalSystem(EntityUtils.normalizeId((String)projectName), systemId, principal.getName());
    }

    @RequestMapping(value={"/clear"}, method={RequestMethod.DELETE})
    @ResponseBody
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete all external system assigned to specified project")
    public OperationCompletionRS deleteAllExternalSystems(@PathVariable String projectName, Principal principal) {
        return this.deleteExternalSystemHandler.deleteAllExternalSystems(EntityUtils.normalizeId((String)projectName), principal.getName());
    }

    @RequestMapping(value={"/{systemId}"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseBody
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update registered external system instance")
    public OperationCompletionRS updateExternalSystem(@Validated @RequestBody UpdateExternalSystemRQ request, @PathVariable String projectName, @PathVariable String systemId, Principal principal) {
        return this.updateExternalSystemHandler.updateExternalSystem(request, EntityUtils.normalizeId((String)projectName), systemId, principal.getName());
    }

    @RequestMapping(value={"/{systemId}/connect"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Check connection to external system instance")
    public OperationCompletionRS jiraConnection(@PathVariable String projectName, @PathVariable String systemId, @RequestBody @Validated UpdateExternalSystemRQ updateRQ, Principal principal) {
        return this.updateExternalSystemHandler.externalSystemConnect(systemId, updateRQ, principal.getName());
    }

    @RequestMapping(value={"/{systemId}/fields-set"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Get list of fields required for posting ticket")
    public List<PostFormField> getSetOfExternalSystemFields(@RequestParam(value="issuetype") String issuetype, @PathVariable String projectName, @PathVariable String systemId) {
        return this.getTicketHandler.getSubmitTicketFields(issuetype, EntityUtils.normalizeId((String)projectName), systemId);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"{systemId}/ticket"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Post ticket to external system")
    public Ticket createIssue(@Validated @RequestBody PostTicketRQ ticketRQ, @PathVariable String projectName, @PathVariable String systemId, Principal principal) {
        return this.createTicketHandler.createIssue(ticketRQ, EntityUtils.normalizeId((String)projectName), systemId, principal.getName());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{systemId}/ticket/{ticketId}"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get ticket from external system")
    public Ticket getTicket(@PathVariable String ticketId, @PathVariable String projectName, @PathVariable String systemId, Principal principal) {
        return this.getTicketHandler.getTicket(ticketId, EntityUtils.normalizeId((String)projectName), systemId);
    }
}

