/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.preference.IGetPreferenceHandler;
import com.epam.ta.reportportal.core.preference.IUpdatePreferenceHandler;
import com.epam.ta.reportportal.core.project.ICreateProjectHandler;
import com.epam.ta.reportportal.core.project.IDeleteProjectHandler;
import com.epam.ta.reportportal.core.project.IGetProjectHandler;
import com.epam.ta.reportportal.core.project.IGetProjectInfoHandler;
import com.epam.ta.reportportal.core.project.IUpdateProjectHandler;
import com.epam.ta.reportportal.core.user.IGetUserHandler;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.controller.IProjectController;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ModelViews;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.Page;
import com.epam.ta.reportportal.ws.model.preference.PreferenceResource;
import com.epam.ta.reportportal.ws.model.preference.UpdatePreferenceRQ;
import com.epam.ta.reportportal.ws.model.project.AssignUsersRQ;
import com.epam.ta.reportportal.ws.model.project.CreateProjectRQ;
import com.epam.ta.reportportal.ws.model.project.ProjectInfoResource;
import com.epam.ta.reportportal.ws.model.project.ProjectResource;
import com.epam.ta.reportportal.ws.model.project.UnassignUsersRQ;
import com.epam.ta.reportportal.ws.model.project.UpdateProjectRQ;
import com.epam.ta.reportportal.ws.model.project.email.ProjectEmailConfigDTO;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.ResponseView;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/project"})
@Api
public class ProjectController
implements IProjectController {
    private final ICreateProjectHandler createProjectHandler;
    private final IUpdateProjectHandler updateProjectHandler;
    private final IDeleteProjectHandler deleteProjectHandler;
    private final IGetProjectHandler getProjectHandler;
    private final IGetPreferenceHandler getPreferenceHandler;
    private final IUpdatePreferenceHandler updatePreferenceHandler;
    private final IGetProjectInfoHandler getProjectInfoHandler;
    private final IGetUserHandler userHandler;

    @Autowired
    public ProjectController(ICreateProjectHandler createProjectHandler, IUpdateProjectHandler updateProjectHandler, IDeleteProjectHandler deleteProjectHandler, IGetProjectHandler getProjectHandler, IGetPreferenceHandler getPreferenceHandler, IUpdatePreferenceHandler updatePreferenceHandler, IGetProjectInfoHandler getProjectInfoHandler, IGetUserHandler userHandler) {
        this.createProjectHandler = createProjectHandler;
        this.updateProjectHandler = updateProjectHandler;
        this.deleteProjectHandler = deleteProjectHandler;
        this.getProjectHandler = getProjectHandler;
        this.getPreferenceHandler = getPreferenceHandler;
        this.updatePreferenceHandler = updatePreferenceHandler;
        this.getProjectInfoHandler = getProjectInfoHandler;
        this.userHandler = userHandler;
    }

    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Create new project")
    public EntryCreatedRS createProject(@RequestBody @Validated CreateProjectRQ createProjectRQ, Principal principal) {
        return this.createProjectHandler.createProject(createProjectRQ, principal.getName());
    }

    @RequestMapping(value={"/{projectName}"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')||hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Update project", notes="'Email Configuration' can be also update via PUT to /{projectName}/emailconfig resource.")
    public OperationCompletionRS updateProject(@PathVariable String projectName, @RequestBody @Validated UpdateProjectRQ updateProjectRQ, Principal principal) {
        return this.updateProjectHandler.updateProject(EntityUtils.normalizeId((String)projectName), updateProjectRQ, principal.getName());
    }

    @RequestMapping(value={"/{projectName}/emailconfig"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Update project email configuration")
    public OperationCompletionRS updateProjectEmailConfig(@PathVariable String projectName, @RequestBody @Validated ProjectEmailConfigDTO updateProjectRQ, Principal principal) {
        return this.updateProjectHandler.updateProjectEmailConfig(EntityUtils.normalizeId((String)projectName), principal.getName(), updateProjectRQ);
    }

    @RequestMapping(value={"/{projectName}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Delete project", notes="Could be deleted only by users with administrator role")
    public OperationCompletionRS deleteProject(@PathVariable String projectName, Principal principal) {
        return this.deleteProjectHandler.deleteProject(EntityUtils.normalizeId((String)projectName));
    }

    @RequestMapping(value={"/{projectName}/users"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseView(value=ModelViews.DefaultView.class)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'notCustomerPermission')")
    @ApiOperation(value="Get users from project")
    public Iterable<UserResource> getProjectUsers(@PathVariable String projectName, @FilterFor(value=User.class) Filter filter, @SortFor(value=User.class) Pageable pageable, Principal principal) {
        return this.getProjectHandler.getProjectUsers(EntityUtils.normalizeId((String)projectName), filter, pageable);
    }

    @RequestMapping(value={"/{projectName}"}, method={RequestMethod.GET})
    @ResponseBody
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @ApiOperation(value="Get information about project", notes="Only for users that are assigned to the project")
    public ProjectResource getProject(@PathVariable String projectName, Principal principal) {
        return this.getProjectHandler.getProject(EntityUtils.normalizeId((String)projectName));
    }

    @RequestMapping(value={"/{projectName}/unassign"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Un assign users")
    public OperationCompletionRS unassignProjectUsers(@PathVariable String projectName, @RequestBody @Validated UnassignUsersRQ unassignUsersRQ, Principal principal) {
        return this.updateProjectHandler.unassignUsers(EntityUtils.normalizeId((String)projectName), principal.getName(), unassignUsersRQ);
    }

    @RequestMapping(value={"/{projectName}/assign"}, method={RequestMethod.PUT}, consumes={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Assign users")
    public OperationCompletionRS assignProjectUsers(@PathVariable String projectName, @RequestBody @Validated AssignUsersRQ assignUsersRQ, Principal principal) {
        return this.updateProjectHandler.assignUsers(EntityUtils.normalizeId((String)projectName), principal.getName(), assignUsersRQ);
    }

    @RequestMapping(value={"/{projectName}/assignable"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseView(value=ModelViews.DefaultView.class)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    @ApiOperation(value="Load users which can be assigned to specified project", notes="Only for users with project manager permissions")
    public Iterable<UserResource> getUsersForAssign(@FilterFor(value=User.class) Filter filter, @SortFor(value=User.class) Pageable pageable, @PathVariable String projectName, Principal principal) {
        return this.userHandler.getUsers(filter, pageable, EntityUtils.normalizeId((String)projectName));
    }

    @RequestMapping(value={"/{projectName}/usernames"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'notCustomerPermission')")
    @ApiOperation(value="Load project users by filter", notes="Only for users that are members of the project")
    public List<String> getProjectUsers(@PathVariable String projectName, @RequestParam(value="filter.cnt.users") String value, Principal principal) {
        return this.getProjectHandler.getUserNames(EntityUtils.normalizeId((String)projectName), EntityUtils.normalizeId((String)value));
    }

    @RequestMapping(value={"/{projectName}/usernames/search/{term:.+}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiIgnore
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectManagerPermission')")
    public Page<UserResource> searchForUser(@PathVariable String projectName, @PathVariable String term, Pageable pageable) {
        return this.getProjectHandler.getUserNames(term, pageable);
    }

    @RequestMapping(value={"/{projectName}/preference/{login}"}, method={RequestMethod.PUT})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name) || hasRole('ADMINISTRATOR')")
    @ApiIgnore
    public OperationCompletionRS updateUserPreference(@PathVariable String projectName, @RequestBody @Validated UpdatePreferenceRQ updatePreferenceRQ, @PathVariable String login, Principal principal) {
        return this.updatePreferenceHandler.updatePreference(principal.getName(), EntityUtils.normalizeId((String)projectName), updatePreferenceRQ);
    }

    @RequestMapping(value={"/{projectName}/preference/{login}"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="(#login.toLowerCase() == authentication.name) || hasRole('ADMINISTRATOR')")
    @ApiOperation(value="Load user preferences", notes="Only for users that allowed to edit other users")
    public PreferenceResource getUserPreference(@PathVariable String projectName, @PathVariable String login, Principal principal) {
        return this.getPreferenceHandler.getPreference(EntityUtils.normalizeId((String)projectName), EntityUtils.normalizeId((String)login));
    }

    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiIgnore
    public Iterable<ProjectInfoResource> getAllProjectsInfo(@FilterFor(value=Project.class) Filter filter, @SortFor(value=Project.class) Pageable pageable, Principal principal) {
        return this.getProjectInfoHandler.getAllProjectsInfo(filter, pageable);
    }

    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @RequestMapping(value={"/list/{projectName}"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseView(value=ModelViews.FullProjectInfoView.class)
    @ResponseStatus(value=HttpStatus.OK)
    @ApiIgnore
    public ProjectInfoResource getProjectInfo(@PathVariable String projectName, @RequestParam(value="interval", required=false, defaultValue="3M") String interval, Principal principal) {
        return this.getProjectInfoHandler.getProjectInfo(EntityUtils.normalizeId((String)projectName), interval);
    }

    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @RequestMapping(value={"/{projectName}/widget/{widgetId}"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseView(value=ModelViews.FullProjectInfoView.class)
    @ResponseStatus(value=HttpStatus.OK)
    @ApiIgnore
    public Map<String, List<ChartObject>> getProjectWidget(@PathVariable String projectName, @RequestParam(value="interval", required=false, defaultValue="3M") String interval, @PathVariable String widgetId, Principal principal) {
        return this.getProjectInfoHandler.getProjectInfoWidgetContent(EntityUtils.normalizeId((String)projectName), interval, widgetId);
    }

    @PreAuthorize(value="hasRole('ADMINISTRATOR')")
    @RequestMapping(value={"/names"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiIgnore
    public Iterable<String> getAllProjectNames(Principal principal) {
        return this.getProjectHandler.getAllProjectNames();
    }
}

