/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.item.DeleteTestItemHandler;
import com.epam.ta.reportportal.core.item.FinishTestItemHandler;
import com.epam.ta.reportportal.core.item.GetTestItemHandler;
import com.epam.ta.reportportal.core.item.StartTestItemHandler;
import com.epam.ta.reportportal.core.item.UpdateTestItemHandler;
import com.epam.ta.reportportal.core.item.history.TestItemsHistoryHandler;
import com.epam.ta.reportportal.core.item.merge.MergeTestItemHandler;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.search.CompositeFilter;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.controller.ITestItemController;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.TestItemHistoryElement;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import com.epam.ta.reportportal.ws.model.issue.DefineIssueRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.item.AddExternalIssueRQ;
import com.epam.ta.reportportal.ws.model.item.MergeTestItemRQ;
import com.epam.ta.reportportal.ws.model.item.UpdateTestItemRQ;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/{projectName}/item"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class TestItemController
implements ITestItemController {
    public static final String DEFAULT_HISTORY_DEPTH = "5";
    public static final String DEFAULT_HISTORY_FULL = "true";
    @Autowired
    private StartTestItemHandler startTestItemHandler;
    @Autowired
    private DeleteTestItemHandler deleteTestItemHandler;
    @Autowired
    private FinishTestItemHandler finishTestItemHandler;
    @Autowired
    private GetTestItemHandler getTestItemHandler;
    @Autowired
    private TestItemsHistoryHandler testItemsHistoryHandler;
    @Autowired
    private UpdateTestItemHandler updateTestItemHandler;
    @Autowired
    private MergeTestItemHandler mergeTestItemHandler;

    @PostMapping
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Start a root test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public EntryCreatedRS startRootItem(@PathVariable String projectName, @RequestBody @Validated StartTestItemRQ startTestItemRQ, Principal principal) {
        return this.startTestItemHandler.startRootItem(projectName, startTestItemRQ);
    }

    @PostMapping(value={"/{parentItem}"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Start a child test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public EntryCreatedRS startChildItem(@PathVariable String projectName, @PathVariable String parentItem, @RequestBody @Validated StartTestItemRQ startTestItemRQ, Principal principal) {
        return this.startTestItemHandler.startChildItem(startTestItemRQ, parentItem);
    }

    @PutMapping(value={"/{testItemId}"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Finish test item")
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'reporterPermission')")
    public OperationCompletionRS finishTestItem(@PathVariable String projectName, @PathVariable String testItemId, @RequestBody @Validated FinishTestItemRQ finishExecutionRQ, Principal principal) {
        return this.finishTestItemHandler.finishTestItem(testItemId, finishExecutionRQ, principal.getName());
    }

    @GetMapping(value={"/{testItemId}"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Find test item by ID")
    public TestItemResource getTestItem(@PathVariable String projectName, @PathVariable String testItemId, Principal principal) {
        return this.getTestItemHandler.getTestItem(testItemId);
    }

    @GetMapping
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Find test items by specified filter")
    public Iterable<TestItemResource> getTestItems(@PathVariable String projectName, @FilterFor(value=TestItem.class) Filter filter, @FilterFor(value=TestItem.class) Queryable predefinedFilter, @SortFor(value=TestItem.class) Pageable pageable, Principal principal) {
        return this.getTestItemHandler.getTestItems((Queryable)new CompositeFilter(new Queryable[]{filter, predefinedFilter}), pageable);
    }

    @DeleteMapping(value={"/{item}"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete test item")
    public OperationCompletionRS deleteTestItem(@PathVariable String projectName, @PathVariable String item, Principal principal) {
        return this.deleteTestItemHandler.deleteTestItem(item, EntityUtils.normalizeId((String)projectName), principal.getName());
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @DeleteMapping
    @ApiOperation(value="Delete test items by specified ids")
    public List<OperationCompletionRS> deleteTestItems(@PathVariable String projectName, @RequestParam(value="ids") String[] ids, Principal principal) {
        return this.deleteTestItemHandler.deleteTestItem(ids, EntityUtils.normalizeId((String)projectName), principal.getName());
    }

    @PutMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Update issues of specified test items")
    public List<Issue> defineTestItemIssueType(@PathVariable String projectName, @RequestBody @Validated DefineIssueRQ request, Principal principal) {
        return this.updateTestItemHandler.defineTestItemsIssues(EntityUtils.normalizeId((String)projectName), request, principal.getName());
    }

    @GetMapping(value={"/history"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Load history of test items")
    public List<TestItemHistoryElement> getItemsHistory(@PathVariable String projectName, @RequestParam(value="history_depth", required=false, defaultValue="5") int historyDepth, @RequestParam(value="ids") String[] ids, @RequestParam(value="is_full", required=false, defaultValue="true") boolean showBrokenLaunches, Principal principal) {
        return this.testItemsHistoryHandler.getItemsHistory(EntityUtils.normalizeId((String)projectName), ids, historyDepth, showBrokenLaunches);
    }

    @GetMapping(value={"/tags"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all unique tags of specified launch")
    public List<String> getAllTags(@PathVariable String projectName, @RequestParam(value="launch") String id, @RequestParam(value="filter.cnt.tags") String value, Principal principal) {
        return this.getTestItemHandler.getTags(id, value);
    }

    @PutMapping(value={"/{item}/update"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @ApiOperation(value="Update test item")
    public OperationCompletionRS updateTestItem(@PathVariable String projectName, @PathVariable String item, @RequestBody @Validated UpdateTestItemRQ rq, Principal principal) {
        return this.updateTestItemHandler.updateTestItem(EntityUtils.normalizeId((String)projectName), item, rq, principal.getName());
    }

    @PutMapping(value={"/issue/add"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @ApiOperation(value="Attach external issue for specified test items")
    public List<OperationCompletionRS> addExternalIssues(@PathVariable String projectName, @RequestBody @Validated AddExternalIssueRQ rq, Principal principal) {
        return this.updateTestItemHandler.addExternalIssues(EntityUtils.normalizeId((String)projectName), rq, principal.getName());
    }

    @GetMapping(value={"/items"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @ApiOperation(value="Get test items by specified ids")
    public List<TestItemResource> getTestItems(@PathVariable String projectName, @RequestParam(value="ids") String[] ids, Principal principal) {
        return this.getTestItemHandler.getTestItems(ids);
    }

    @PutMapping(value={"/{item}/merge"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @ApiIgnore
    public OperationCompletionRS mergeTestItem(@PathVariable String projectName, @PathVariable String item, @RequestBody @Validated MergeTestItemRQ rq, Principal principal) {
        return this.mergeTestItemHandler.mergeTestItem(EntityUtils.normalizeId((String)projectName), item, rq, principal.getName());
    }
}

