/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.resolver;

import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.ws.resolver.ActiveRole;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class ActiveUserWebArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().equals(UserRole.class) && null != methodParameter.getParameterAnnotation(ActiveRole.class);
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer paramModelAndViewContainer, NativeWebRequest webRequest, WebDataBinderFactory paramWebDataBinderFactory) throws Exception {
        Authentication authentication = (Authentication)webRequest.getUserPrincipal();
        if (!authentication.getAuthorities().isEmpty()) {
            Optional userRole = UserRole.findByAuthority((String)((GrantedAuthority)authentication.getAuthorities().iterator().next()).getAuthority());
            return userRole.isPresent() ? userRole.get() : WebArgumentResolver.UNRESOLVED;
        }
        return WebArgumentResolver.UNRESOLVED;
    }
}

