/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.acl.chain;

import com.epam.ta.reportportal.core.acl.chain.ChainElement;
import com.epam.ta.reportportal.core.acl.chain.IChainElement;
import com.epam.ta.reportportal.database.dao.DashboardRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.database.entity.sharing.Shareable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="DashboardChainElement")
public class DashboardChainElement
extends ChainElement {
    @Autowired
    private WidgetRepository widgetRepository;
    @Autowired
    private DashboardRepository dashboardRepository;

    @Autowired
    public DashboardChainElement(@Qualifier(value="WidgetChainElement") IChainElement nextChainElement) {
        super(nextChainElement);
    }

    public boolean isCanHandle(List<? extends Shareable> elementsToProcess) {
        return Dashboard.class.equals(elementsToProcess.get(0).getClass());
    }

    public List<? extends Shareable> getNextElements(List<? extends Shareable> elementsToProcess, String owner) {
        Set ids = elementsToProcess.stream().map(e -> (Dashboard)e).flatMap(d -> d.getWidgets().stream()).map(Dashboard.WidgetObject::getWidgetId).collect(Collectors.toSet());
        if (!ids.isEmpty()) {
            return this.widgetRepository.findOnlyOwnedEntities(ids, owner);
        }
        return Collections.emptyList();
    }

    public void saveElements(List<? extends Shareable> elementsToProcess) {
        this.dashboardRepository.save((Iterable)elementsToProcess.stream().map(input -> (Dashboard)input).collect(Collectors.toList()));
    }
}

