/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.acl.SharingService;
import com.epam.ta.reportportal.core.dashboard.IUpdateDashboardHandler;
import com.epam.ta.reportportal.database.dao.DashboardRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.events.DashboardUpdatedEvent;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.dashboard.UpdateDashboardRQ;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdateDashboardHandler
implements IUpdateDashboardHandler {
    private final DashboardRepository dashboardRepository;
    private final WidgetRepository widgetRepository;
    private final SharingService sharingService;
    private final ApplicationEventPublisher eventPublisher;
    private final ProjectRepository projectRepository;

    @Autowired
    public UpdateDashboardHandler(DashboardRepository dashboardRepository, WidgetRepository widgetRepository, SharingService sharingService, ApplicationEventPublisher eventPublisher, ProjectRepository projectRepository) {
        this.dashboardRepository = dashboardRepository;
        this.widgetRepository = widgetRepository;
        this.sharingService = sharingService;
        this.eventPublisher = eventPublisher;
        this.projectRepository = projectRepository;
    }

    public OperationCompletionRS updateDashboard(UpdateDashboardRQ rq, String dashboardId, String userName, String projectName, UserRole userRole) {
        StringBuilder additionalInfo = new StringBuilder();
        Dashboard dashboard = (Dashboard)this.dashboardRepository.findOne((Serializable)((Object)dashboardId));
        BusinessRule.expect((Object)dashboard, (Predicate)Predicates.notNull()).verify(ErrorType.DASHBOARD_NOT_FOUND, new Object[]{dashboardId});
        Map projectRoles = this.projectRepository.findProjectRoles(userName);
        AclUtils.isAllowedToEdit((Acl)dashboard.getAcl(), (String)userName, (Map)projectRoles, (String)dashboard.getName(), (UserRole)userRole);
        BusinessRule.expect((Object)dashboard.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        Optional.ofNullable(rq.getName()).ifPresent(it -> {
            Dashboard isExist = this.dashboardRepository.findOneByUserProject(userName, projectName, rq.getName());
            if (isExist != null && !dashboardId.equalsIgnoreCase(isExist.getId())) {
                BusinessRule.fail().withError(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{rq.getName()});
            }
            dashboard.setName(it.trim());
        });
        Optional.ofNullable(rq.getDescription()).ifPresent(arg_0 -> ((Dashboard)dashboard).setDescription(arg_0));
        BusinessRule.expect((Object)(null != rq.getAddWidget() && null != rq.getDeleteWidgetId() && rq.getDeleteWidgetId().equalsIgnoreCase(rq.getAddWidget().getWidgetId()) ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.DASHBOARD_UPDATE_ERROR, new Object[]{"Unable delete and add the same widget simultaneously."});
        Optional.ofNullable(rq.getWidgets()).ifPresent(rqWidgets -> {
            for (Dashboard.WidgetObject widget : dashboard.getWidgets()) {
                rqWidgets.stream().filter(updWidget -> widget.getWidgetId().equalsIgnoreCase(updWidget.getWidgetId())).forEach(updWidget -> {
                    Optional.ofNullable(updWidget.getWidgetPosition()).ifPresent(arg_0 -> ((Dashboard.WidgetObject)widget).setWidgetPosition(arg_0));
                    Optional.ofNullable(updWidget.getWidgetSize()).ifPresent(arg_0 -> ((Dashboard.WidgetObject)widget).setWidgetSize(arg_0));
                });
            }
        });
        if (null != rq.getAddWidget()) {
            Widget widget = (Widget)this.widgetRepository.findOneLoadACL((Serializable)((Object)rq.getAddWidget().getWidgetId()));
            this.validateAddingWidget(dashboard.getWidgets(), widget, rq.getAddWidget().getWidgetId(), userName, projectName);
            if (null == rq.getAddWidget().getWidgetPosition() || rq.getAddWidget().getWidgetPosition().size() < 2) {
                ArrayList<Integer> widgetPosition = new ArrayList<Integer>();
                int yPosition = 0;
                int xPosition = 0;
                List widgets = dashboard.getWidgets();
                for (Dashboard.WidgetObject widgetObject : widgets) {
                    if (widgetObject.getWidgetPosition().size() <= 1 || (Integer)widgetObject.getWidgetPosition().get(1) <= yPosition) continue;
                    yPosition = (Integer)widgetObject.getWidgetPosition().get(1);
                }
                widgetPosition.add(xPosition);
                widgetPosition.add(++yPosition);
                rq.getAddWidget().setWidgetPosition(widgetPosition);
            }
            dashboard.getWidgets().add(new Dashboard.WidgetObject(widget.getId(), rq.getAddWidget().getWidgetSize(), rq.getAddWidget().getWidgetPosition()));
            if (!dashboard.getAcl().getEntries().isEmpty() && widget.getAcl().getEntries().isEmpty()) {
                this.sharingService.modifySharing((List)Lists.newArrayList((Object[])new Dashboard[]{dashboard}), userName, projectName, true);
                additionalInfo.append("Widget '");
                additionalInfo.append(rq.getAddWidget().getWidgetId());
                additionalInfo.append("' has been shared for project cause shared dashboard.");
            }
        }
        Optional.ofNullable(rq.getDeleteWidgetId()).ifPresent(it -> {
            BusinessRule.expect((Object)dashboard.getWidgets(), (Predicate)this.hasWidget(it)).verify(ErrorType.WIDGET_NOT_FOUND_IN_DASHBOARD, new Object[]{it, dashboardId});
            dashboard.getWidgets().removeIf(w -> w.getWidgetId().equals(it));
            Widget widget = (Widget)this.widgetRepository.findOneLoadACL((Serializable)((Object)it));
            if (null != widget && AclUtils.isAllowedToDeleteWidget((Acl)dashboard.getAcl(), (Acl)widget.getAcl(), (String)userName, (ProjectRole)((ProjectRole)projectRoles.get(projectName)), (UserRole)userRole)) {
                this.widgetRepository.delete((Serializable)((Object)it));
            }
        });
        Optional.ofNullable(rq.getShare()).ifPresent(it -> this.sharingService.modifySharing((List)Lists.newArrayList((Object[])new Dashboard[]{dashboard}), userName, projectName, it.booleanValue()));
        this.dashboardRepository.save((Object)dashboard);
        this.eventPublisher.publishEvent((Object)new DashboardUpdatedEvent(dashboard, rq, userName));
        return new OperationCompletionRS("Dashboard with ID = '" + dashboard.getId() + "' successfully updated." + additionalInfo.toString());
    }

    private void validateAddingWidget(List<Dashboard.WidgetObject> allWidgets, Widget widgetFromDB, String widgetId, String userName, String projectName) {
        BusinessRule.expect((Object)widgetFromDB, (Predicate)Predicates.notNull()).verify(ErrorType.WIDGET_NOT_FOUND, new Object[]{widgetId});
        BusinessRule.expect((Object)widgetFromDB.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Impossible to add widget from another project"});
        BusinessRule.expect(allWidgets, this.hasWidget(widgetId).negate()).verify(ErrorType.DASHBOARD_UPDATE_ERROR, new Object[]{Suppliers.formattedSupplier((String)"Widget with ID '{}' already added to the current dashboard.", (Object[])new Object[]{widgetId})});
        AclUtils.isPossibleToRead((Acl)widgetFromDB.getAcl(), (String)userName, (String)projectName);
    }

    private Predicate<List<Dashboard.WidgetObject>> hasWidget(String id) {
        return widgets -> widgets.stream().anyMatch(w -> w.getWidgetId().equals(id));
    }
}

