/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.CriteriaHolder;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.filter.UserFilterEntity;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserFilterValidationService {
    @Autowired
    private UserFilterRepository userFilterRepository;
    @Autowired
    private CriteriaMapFactory criteriaMapFactory;

    public void isFilterNameUnique(String userName, String filterName, String projectName) {
        UserFilter existingFilter = this.userFilterRepository.findOneByName(userName, filterName, projectName);
        BusinessRule.expect((Object)existingFilter, (Predicate)Predicates.isNull()).verify(ErrorType.USER_FILTER_ALREADY_EXISTS, new Object[]{filterName, userName, projectName});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UserFilterEntity> validateUserFilterEntities(Class<?> type, Set<UserFilterEntity> filterEntities) {
        CriteriaMap ctriteriaMap = this.criteriaMapFactory.getCriteriaMap(type);
        UserFilterValidationService userFilterValidationService = this;
        synchronized (userFilterValidationService) {
            for (UserFilterEntity userFilterEntity : filterEntities) {
                Optional holderOptional = ctriteriaMap.getCriteriaHolderUnchecked(userFilterEntity.getFilteringField());
                BusinessRule.expect((Object)holderOptional, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Filter parameter {} is not defined", (Object[])new Object[]{userFilterEntity.getFilteringField()})});
                CriteriaHolder updated = null;
                boolean reload = false;
                BusinessRule.expect((Object)holderOptional.isPresent(), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.BAD_SAVE_USER_FILTER_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Filtering field '{}' is unknown.", (Object[])new Object[]{userFilterEntity.getFilteringField()})});
                Condition condition = Condition.findByMarker((String)userFilterEntity.getCondition());
                BusinessRule.expect((Object)condition, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_SAVE_USER_FILTER_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Incorrect filter's entity condition '{}'.", (Object[])new Object[]{userFilterEntity.getCondition()})});
                if (!reload) {
                    condition.validate((CriteriaHolder)holderOptional.get(), userFilterEntity.getValue(), userFilterEntity.getIsNegative(), ErrorType.BAD_SAVE_USER_FILTER_REQUEST);
                    condition.castValue((CriteriaHolder)holderOptional.get(), userFilterEntity.getValue(), ErrorType.BAD_SAVE_USER_FILTER_REQUEST);
                    continue;
                }
                condition.validate(updated, userFilterEntity.getValue(), userFilterEntity.getIsNegative(), ErrorType.BAD_SAVE_USER_FILTER_REQUEST);
                condition.castValue(updated, userFilterEntity.getValue(), ErrorType.BAD_SAVE_USER_FILTER_REQUEST);
            }
        }
        return filterEntities;
    }

    public void validateSortingColumnName(Class<?> type, String sortingColumnName) {
        BusinessRule.expect((Object)this.criteriaMapFactory.getCriteriaMap(type).getCriteriaHolderUnchecked(sortingColumnName).isPresent(), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.BAD_SAVE_USER_FILTER_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Column for sorting with name '{}' is unknown.", (Object[])new Object[]{sortingColumnName})});
    }
}

