/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item;

import com.epam.ta.reportportal.core.item.UniqueIdGenerator;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestItemUniqueIdGenerator
implements UniqueIdGenerator {
    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static final String SECRET = "auto:";
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private LaunchRepository launchRepository;

    public String generate(TestItem testItem, String projectName) {
        String forEncoding = this.prepareForEncoding(testItem, projectName);
        return ENCODER.encodeToString(forEncoding.getBytes(StandardCharsets.UTF_8));
    }

    public boolean validate(String encoded) {
        return !Strings.isNullOrEmpty((String)encoded) && new String(DECODER.decode(encoded), StandardCharsets.UTF_8).startsWith(SECRET);
    }

    private String prepareForEncoding(TestItem testItem, String projectName) {
        String launchName = this.launchRepository.findNameNumberAndModeById(testItem.getLaunchRef()).getName();
        List pathNames = this.getPathNames(testItem.getPath());
        String itemName = testItem.getName();
        List parameters = Optional.ofNullable(testItem.getParameters()).orElse(Collections.emptyList());
        StringJoiner joiner = new StringJoiner(";");
        joiner.add(SECRET).add(projectName).add(launchName);
        if (!CollectionUtils.isEmpty((Collection)pathNames)) {
            joiner.add(pathNames.stream().collect(Collectors.joining(",")));
        }
        joiner.add(itemName);
        if (!parameters.isEmpty()) {
            joiner.add(parameters.stream().map(parameter -> (!Strings.isNullOrEmpty((String)parameter.getKey()) ? parameter.getKey() + "=" : "") + parameter.getValue()).collect(Collectors.joining(",")));
        }
        return joiner.toString();
    }

    private List<String> getPathNames(List<String> path) {
        Map names = this.testItemRepository.findPathNames(path);
        return path.stream().map(names::get).collect(Collectors.toList());
    }
}

