/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.history;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.item.history.HistoryUtils;
import com.epam.ta.reportportal.core.item.history.ITestItemsHistoryService;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class TestItemsHistoryService
implements ITestItemsHistoryService {
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private LaunchRepository launchRepository;

    public List<TestItem> loadItems(List<String> startingPointIds) {
        return Lists.newArrayList((Iterable)this.testItemRepository.findAll(startingPointIds));
    }

    public List<Launch> loadLaunches(int quantity, String startingLaunchId, String projectName, boolean showBrokenLaunches) {
        Launch startingLaunch = this.launchRepository.findNameNumberAndModeById(startingLaunchId);
        if (startingLaunch == null) {
            return Collections.emptyList();
        }
        if (startingLaunch.getMode() == Mode.DEBUG) {
            return Collections.singletonList(startingLaunch);
        }
        Filter filter = HistoryUtils.getLaunchSelectionFilter((String)startingLaunch.getName(), (String)projectName, (Date)startingLaunch.getStartTime(), (boolean)showBrokenLaunches);
        return this.launchRepository.findIdsByFilter(filter, new Sort(Sort.Direction.DESC, new String[]{"start_time"}), quantity);
    }

    public void validateItems(List<TestItem> itemsForHistory, List<String> ids, String projectName) {
        BusinessRule.expect(itemsForHistory, (Predicate)Preconditions.NOT_EMPTY_COLLECTION).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Unable to find history for items '" + ids + "'."});
        Set projectIds = this.launchRepository.find((Collection)itemsForHistory.stream().map(TestItem::getLaunchRef).collect(Collectors.toList())).stream().map(Launch::getProjectRef).collect(Collectors.toSet());
        BusinessRule.expect((Object)(projectIds.size() == 1 && projectIds.contains(projectName) ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Unable to find history for items '" + ids + "'."});
        ids.removeAll(itemsForHistory.stream().map(TestItem::getId).collect(Collectors.toList()));
        BusinessRule.expect((Object)ids.isEmpty(), (Predicate)Predicates.equalTo((Object)Boolean.TRUE)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"Unable to find history for items '" + ids + "'."});
        this.checkItemsIsSiblings(itemsForHistory);
    }

    private void checkItemsIsSiblings(List<TestItem> itemsForHistory) {
        if (itemsForHistory == null || itemsForHistory.isEmpty()) {
            return;
        }
        String parentId = itemsForHistory.get(0).getParent();
        if (parentId == null) {
            String launchRef = itemsForHistory.get(0).getLaunchRef();
            for (TestItem testItem : itemsForHistory) {
                BusinessRule.expect((Object)testItem, (Predicate)Preconditions.hasSameLaunch((String)launchRef)).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"All test items should be siblings."});
            }
        } else {
            BusinessRule.expect(itemsForHistory, (Predicate)Predicates.not((Predicate)Preconditions.contains((Predicate)Predicates.not((Predicate)Preconditions.hasSameParent((String)parentId))))).verify(ErrorType.UNABLE_LOAD_TEST_ITEM_HISTORY, new Object[]{"All test items should be siblings."});
        }
    }
}

