/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.item.merge.strategy;

import com.epam.ta.reportportal.core.item.merge.strategy.MergeStrategy;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.item.Parameter;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public abstract class AbstractSuiteMergeStrategy
implements MergeStrategy {
    protected final TestItemRepository testItemRepository;

    AbstractSuiteMergeStrategy(TestItemRepository testItemRepository) {
        this.testItemRepository = testItemRepository;
    }

    public abstract TestItem mergeTestItems(TestItem var1, List<TestItem> var2);

    public abstract boolean isTestItemAcceptableToMerge(TestItem var1);

    private TestItem moveAllChildTestItems(TestItem itemTarget, TestItem itemSource) {
        for (TestItem childItem : this.testItemRepository.findAllDescendants(itemSource.getId())) {
            childItem.setParent(itemTarget.getId());
            childItem.setLaunchRef(itemTarget.getLaunchRef());
            ArrayList<String> path = new ArrayList<String>(itemTarget.getPath());
            path.add(itemTarget.getId());
            childItem.setPath(path);
            this.setLaunchRefForChilds(childItem, itemTarget.getLaunchRef());
            this.testItemRepository.save((Object)childItem);
        }
        this.updateTargetItemInfo(itemTarget, itemSource);
        this.testItemRepository.delete((Object)itemSource);
        return itemTarget;
    }

    TestItem moveAllChildTestItems(TestItem itemTarget, List<TestItem> items) {
        TestItem result = items.stream().reduce(itemTarget, (arg_0, arg_1) -> this.moveAllChildTestItems(arg_0, arg_1));
        this.mergeAllChildItems(result);
        return result;
    }

    private void setLaunchRefForChilds(TestItem testItemParent, String launchRef) {
        List childItems = this.testItemRepository.findAllDescendants(testItemParent.getId());
        for (TestItem child : childItems) {
            child.setLaunchRef(launchRef);
            ArrayList<String> path = new ArrayList<String>(testItemParent.getPath());
            path.add(testItemParent.getId());
            child.setPath(path);
            this.testItemRepository.save((Object)child);
            if (!child.hasChilds()) continue;
            this.setLaunchRefForChilds(child, launchRef);
        }
    }

    protected void mergeAllChildItems(TestItem testItemParent) {
        List childItems = this.testItemRepository.findAllDescendants(testItemParent.getId());
        List suites = childItems.stream().filter(arg_0 -> this.isTestItemAcceptableToMerge(arg_0)).collect(Collectors.toList());
        suites.stream().collect(Collectors.groupingBy(TestItem::getName)).forEach((key, value) -> this.moveAllChildTestItems((TestItem)value.get(0), value.subList(1, value.size())));
    }

    private void updateTargetItemInfo(TestItem target, TestItem source) {
        List parameters;
        String result;
        Set tags = this.mergeTags((target = this.updateTime(target, source)).getTags(), source.getTags());
        if (!tags.isEmpty()) {
            target.setTags(tags);
        }
        if (!(result = this.mergeDescriptions(target.getItemDescription(), source.getItemDescription())).isEmpty()) {
            target.setItemDescription(result);
        }
        if ((parameters = this.mergeParameters(target.getParameters(), source.getParameters())).equals(source.getParameters())) {
            target.setUniqueId(source.getUniqueId());
        }
        this.testItemRepository.save((Object)target);
    }

    private TestItem updateTime(TestItem target, TestItem source) {
        target.setStartTime(target.getStartTime().before(source.getStartTime()) ? target.getStartTime() : source.getStartTime());
        target.setEndTime(target.getEndTime().after(source.getEndTime()) ? target.getEndTime() : source.getEndTime());
        return target;
    }

    private Set<String> mergeTags(@Nullable Set<String> first, @Nullable Set<String> second) {
        return Stream.concat(first != null ? first.stream() : Stream.empty(), second != null ? second.stream() : Stream.empty()).collect(Collectors.toSet());
    }

    private String mergeDescriptions(@Nullable String first, @Nullable String second) {
        return new StringJoiner("\r\n").add(first != null ? first : "").add(second != null ? second : "").toString();
    }

    private List<Parameter> mergeParameters(@Nullable List<Parameter> first, @Nullable List<Parameter> second) {
        return Stream.concat(first != null ? first.stream() : Stream.empty(), second != null ? second.stream() : Stream.empty()).collect(Collectors.toList());
    }
}

