/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.WidgetContentProvider;
import com.epam.ta.reportportal.database.entity.filter.SelectionOptions;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ActivityFilterStrategy")
public class ActivityFilterStrategy
implements BuildFilterStrategy {
    public static final Integer QUANTITY = 50;
    private static final Integer PAGE_NUMBER = 1;
    private static final String LAST_MODIFIED = "last_modified";
    private static final String SEPARATOR = ",";
    private static final String[] options = new String[]{"actionType", "userRef", "objectType"};
    @Autowired
    private WidgetContentProvider widgetContentProvider;

    public Map<String, List<ChartObject>> buildFilterAndLoadContent(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        Filter searchFilter = new Filter(Activity.class, Condition.EQUALS, false, projectName, "projectRef");
        if (null != contentOptions.getWidgetOptions()) {
            Map widgetOptions = contentOptions.getWidgetOptions();
            for (String option : options) {
                if (!widgetOptions.containsKey(option)) continue;
                searchFilter.addCondition(this.buildFilterCondition(option, (List)widgetOptions.get(option)));
            }
        }
        SelectionOptions selectionOptions = new SelectionOptions();
        selectionOptions.setIsAsc(false);
        selectionOptions.setSortingColumnName(LAST_MODIFIED);
        selectionOptions.setPageNumber(PAGE_NUMBER.intValue());
        return this.widgetContentProvider.getChartContent(projectName, searchFilter, selectionOptions, contentOptions);
    }

    public Map<String, List<ChartObject>> loadContentOfLatestLaunches(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        throw new ReportPortalException("Operation is not supported for this strategy");
    }

    private FilterCondition buildFilterCondition(String searchCriteria, List<String> values) {
        Condition condition = null != values && values.size() > 1 ? Condition.IN : Condition.EQUALS;
        return new FilterCondition(condition, false, StringUtils.join(values, (String)SEPARATOR), searchCriteria);
    }
}

