/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.database.StatisticsDocumentHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.stereotype.Service;

@Service(value="CasesTrendContentLoader")
public class CasesTrendContentLoader
extends StatisticBasedContentLoader
implements IContentLoadingStrategy {
    private static final String COLLECTION = "launch";
    private static final String SORT_FIELD = "start_time";
    private static final String DELTA = "delta";
    @Autowired
    private LaunchRepository launchRepository;

    public Map<String, List<ChartObject>> loadContent(String projectName, Filter filter, Sort sorting, int quantity, List<String> contentFields, List<String> metaDataFields, Map<String, List<String>> options) {
        BusinessRule.expect((Object)(metaDataFields == null || metaDataFields.isEmpty() ? 1 : 0), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Metadata fields should exist for providing content."});
        if (filter.getTarget().getCanonicalName().equalsIgnoreCase(TestItem.class.getName())) {
            return Collections.emptyMap();
        }
        ImmutableList allFields = ImmutableList.builder().addAll(contentFields).addAll(metaDataFields).build();
        StatisticsDocumentHandler handler = new StatisticsDocumentHandler(contentFields, metaDataFields);
        String field = ((Sort.Order)sorting.iterator().next()).getProperty();
        if (!field.equalsIgnoreCase(SORT_FIELD)) {
            sorting = new Sort(Sort.Direction.DESC, new String[]{SORT_FIELD});
        }
        this.launchRepository.loadWithCallback((Queryable)filter, sorting, quantity, (List)allFields, (DocumentCallbackHandler)handler, COLLECTION);
        List rawData = handler.getResult();
        LinkedHashMap<String, List<ChartObject>> result = new LinkedHashMap();
        if (options.get("timeline") != null && StatisticBasedContentLoader.Period.findByName((String)options.get("timeline").get(0)) != null) {
            Map timeline = this.maxByDate(rawData, StatisticBasedContentLoader.Period.findByName((String)options.get("timeline").get(0)), this.getTotalFieldName());
            result.putAll(this.calculateGroupedDiffs(timeline, sorting));
        } else {
            result = this.calculateDiffs(rawData, sorting);
        }
        return result;
    }

    private Map<String, List<ChartObject>> calculateGroupedDiffs(Map<String, List<ChartObject>> initial, Sort sorting) {
        if (initial.keySet().isEmpty()) {
            return Collections.emptyMap();
        }
        if (sorting.toString().contains(Sort.Direction.ASC.name())) {
            ArrayList<String> keys = new ArrayList<String>(initial.keySet());
            Integer previous = Integer.valueOf((String)initial.get(keys.get(keys.size() - 1)).get(0).getValues().get(this.getTotalFieldName()));
            for (int i = keys.size() - 1; i >= 0; --i) {
                Integer current = Integer.valueOf((String)initial.get(keys.get(i)).get(0).getValues().get(this.getTotalFieldName()));
                initial.get(keys.get(i)).get(0).getValues().put(DELTA, String.valueOf(current - previous));
                previous = current;
            }
        } else {
            Integer previous = Integer.valueOf((String)initial.get(initial.keySet().iterator().next()).get(0).getValues().get(this.getTotalFieldName()));
            for (Map.Entry<String, List<ChartObject>> entry : initial.entrySet()) {
                Integer current = Integer.valueOf((String)entry.getValue().get(0).getValues().get(this.getTotalFieldName()));
                entry.getValue().get(0).getValues().put(DELTA, String.valueOf(current - previous));
                previous = current;
            }
        }
        return initial;
    }

    private Map<String, List<ChartObject>> calculateDiffs(List<ChartObject> initial, Sort sorting) {
        Integer previous;
        if (initial.isEmpty()) {
            return new HashMap<String, List<ChartObject>>();
        }
        if (sorting.toString().contains(Sort.Direction.DESC.name())) {
            previous = Integer.valueOf((String)initial.get(initial.size() - 1).getValues().get(this.getTotalFieldName()));
            for (int i = initial.size() - 1; i >= 0; --i) {
                Integer current = Integer.valueOf((String)initial.get(i).getValues().get(this.getTotalFieldName()));
                initial.get(i).getValues().put(DELTA, String.valueOf(current - previous));
                previous = current;
            }
        } else {
            previous = Integer.valueOf((String)initial.get(0).getValues().get(this.getTotalFieldName()));
            for (ChartObject anInitial : initial) {
                Integer current = Integer.valueOf((String)anInitial.getValues().get(this.getTotalFieldName()));
                anInitial.getValues().put(DELTA, String.valueOf(current - previous));
                previous = current;
            }
        }
        HashMap<String, List<ChartObject>> result = new HashMap<String, List<ChartObject>>();
        result.put("result", initial);
        return result;
    }
}

