/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.database.StatisticsDocumentHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="LaunchStatisticsChartContentLoader")
public class LaunchStatisticsChartContentLoader
extends StatisticBasedContentLoader
implements IContentLoadingStrategy {
    @Autowired
    private LaunchRepository launchRepository;

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    public Map<String, List<ChartObject>> loadContent(String projectName, Filter filter, Sort sorting, int quantity, List<String> contentFields, List<String> metaDataFields, Map<String, List<String>> options) {
        BusinessRule.expect((Object)(metaDataFields == null || metaDataFields.isEmpty() ? 1 : 0), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Metadata fields should exist for providing content for 'Launch Statistics Chart'."});
        ImmutableList allFields = ImmutableList.builder().addAll(contentFields).addAll(metaDataFields).build();
        StatisticsDocumentHandler handler = new StatisticsDocumentHandler(contentFields, metaDataFields);
        String collectionName = LaunchStatisticsChartContentLoader.getCollectionName((Class)filter.getTarget());
        quantity = 1;
        this.launchRepository.loadWithCallback((Queryable)filter, sorting, quantity, (List)allFields, (DocumentCallbackHandler)handler, collectionName);
        Map result = this.convertResult(handler);
        if (options.get("timeline") != null && StatisticBasedContentLoader.Period.findByName((String)options.get("timeline").get(0)) != null) {
            return this.groupByDate(handler.getResult(), StatisticBasedContentLoader.Period.findByName((String)options.get("timeline").get(0)));
        }
        return result;
    }

    private Map<String, List<ChartObject>> convertResult(StatisticsDocumentHandler handler) {
        HashMap<String, List<ChartObject>> asResult = new HashMap<String, List<ChartObject>>();
        List initial = handler.getResult();
        ChartObject chartObject = new ChartObject();
        chartObject.setValues(new HashMap());
        asResult.put("result", Collections.singletonList(!initial.isEmpty() ? (ChartObject)initial.get(0) : chartObject));
        return asResult;
    }
}

