/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.core.widget.content.BuildFilterStrategy;
import com.epam.ta.reportportal.core.widget.content.WidgetContentProvider;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.database.search.FilterConditionUtils;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service(value="UniqueBugFilterStrategy")
public class UniqueBugFilterStrategy
implements BuildFilterStrategy {
    private static final String SEPARATOR = ",";
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private WidgetContentProvider widgetContentProvider;
    @Autowired
    private CriteriaMapFactory criteriaMapFactory;

    public Map<String, List<ChartObject>> buildFilterAndLoadContent(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        Filter filter = userFilter.getFilter();
        if (filter.getTarget().equals(Launch.class)) {
            filter.addCondition(new FilterCondition(Condition.EQUALS, false, projectName, "project"));
            filter.addCondition(FilterConditionUtils.LAUNCH_IN_DEFAULT_MODE());
            filter.addCondition(FilterConditionUtils.LAUNCH_NOT_IN_PROGRESS());
            int limit = contentOptions.getItemsCount();
            CriteriaMap criteriaMap = this.criteriaMapFactory.getCriteriaMap(filter.getTarget());
            List launches = this.launchRepository.findIdsByFilter(filter, new Sort(userFilter.getSelectionOptions().isAsc() ? Sort.Direction.ASC : Sort.Direction.DESC, new String[]{criteriaMap.getCriteriaHolder(userFilter.getSelectionOptions().getSortingColumnName()).getQueryCriteria()}), limit);
            String value = launches.stream().map(Launch::getId).collect(Collectors.joining(SEPARATOR));
            filter = new Filter(TestItem.class, (Set)Sets.newHashSet((Object[])new FilterCondition[]{new FilterCondition(Condition.IN, false, value, "launch")}));
        }
        filter.addCondition(new FilterCondition(Condition.EXISTS, false, "true", "issue$externalSystemIssues"));
        return this.widgetContentProvider.getChartContent(projectName, filter, userFilter.getSelectionOptions(), contentOptions);
    }

    public Map<String, List<ChartObject>> loadContentOfLatestLaunches(UserFilter userFilter, ContentOptions contentOptions, String projectName) {
        throw new ReportPortalException("Operation is not supported for this strategy");
    }
}

