/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.acl.SharingService;
import com.epam.ta.reportportal.core.widget.IUpdateWidgetHandler;
import com.epam.ta.reportportal.core.widget.content.GadgetTypes;
import com.epam.ta.reportportal.core.widget.impl.WidgetUtils;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.entity.widget.ContentOptions;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.database.search.CriteriaMap;
import com.epam.ta.reportportal.database.search.CriteriaMapFactory;
import com.epam.ta.reportportal.events.WidgetUpdatedEvent;
import com.epam.ta.reportportal.ws.converter.builders.WidgetBuilder;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Provider;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class UpdateWidgetHandler
implements IUpdateWidgetHandler {
    @Autowired
    private WidgetRepository widgetRepository;
    @Autowired
    private UserFilterRepository filterRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private Provider<WidgetBuilder> widgetBuilder;
    @Autowired
    private CriteriaMapFactory criteriaMapFactory;
    @Autowired
    private SharingService sharingService;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public OperationCompletionRS updateWidget(String widgetId, WidgetRQ updateRQ, String userName, String projectName, UserRole userRole) {
        Widget widget = (Widget)this.widgetRepository.findOne((Serializable)((Object)widgetId));
        Widget beforeUpdate = (Widget)SerializationUtils.clone((Serializable)widget);
        BusinessRule.expect((Object)widget, (Predicate)Predicates.notNull()).verify(ErrorType.WIDGET_NOT_FOUND, new Object[]{widgetId});
        List widgetList = this.widgetRepository.findByProjectAndUser(projectName, userName);
        if (null != updateRQ.getName() && !widget.getName().equals(updateRQ.getName())) {
            WidgetUtils.checkUniqueName((String)updateRQ.getName(), (List)widgetList);
        }
        widget.setDescription(updateRQ.getDescription());
        AclUtils.isAllowedToEdit((Acl)widget.getAcl(), (String)userName, (Map)this.projectRepository.findProjectRoles(userName), (String)widget.getName(), (UserRole)userRole);
        BusinessRule.expect((Object)widget.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        UserFilter newFilter = null;
        if (null != updateRQ.getApplyingFilter()) {
            String filterId = updateRQ.getApplyingFilter();
            newFilter = this.filterRepository.findOneLoadACL(userName, filterId, projectName);
            if (null == updateRQ.getContentParameters() || !GadgetTypes.findByName((String)updateRQ.getContentParameters().getGadget()).isPresent() || GadgetTypes.findByName((String)updateRQ.getContentParameters().getGadget()).get() != GadgetTypes.ACTIVITY || GadgetTypes.findByName((String)updateRQ.getContentParameters().getGadget()).get() != GadgetTypes.MOST_FAILED_TEST_CASES) {
                BusinessRule.expect((Object)newFilter, (Predicate)Predicates.notNull()).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{updateRQ.getApplyingFilter(), userName});
                BusinessRule.expect((Object)newFilter.isLink(), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.UNABLE_TO_CREATE_WIDGET, new Object[]{"Widget cannot be based on a link"});
            }
        }
        Widget newWidget = (Widget)((WidgetBuilder)this.widgetBuilder.get()).addWidgetRQ(updateRQ).build();
        this.validateWidgetFields(newWidget, newFilter, widget, userName, projectName);
        this.updateWidget(widget, newWidget, newFilter);
        this.shareIfRequired(updateRQ.getShare(), widget, userName, projectName, newFilter);
        this.widgetRepository.save((Object)widget);
        this.eventPublisher.publishEvent((Object)new WidgetUpdatedEvent(beforeUpdate, updateRQ, userName));
        return new OperationCompletionRS("Widget with ID = '" + widget.getId() + "' successfully updated.");
    }

    private void shareIfRequired(Boolean isShare, Widget widget, String userName, String projectName, UserFilter newFilter) {
        if (isShare != null) {
            if (null != newFilter) {
                AclUtils.isPossibleToRead((Acl)newFilter.getAcl(), (String)userName, (String)projectName);
            }
            this.sharingService.modifySharing((List)Lists.newArrayList((Object[])new Widget[]{widget}), userName, projectName, isShare.booleanValue());
        }
    }

    private void updateWidget(Widget oldWidget, Widget newValues, UserFilter filter) {
        if (newValues.getContentOptions() != null) {
            oldWidget.setContentOptions(newValues.getContentOptions());
        }
        if (newValues.getName() != null) {
            oldWidget.setName(newValues.getName());
        }
        if (filter != null) {
            oldWidget.setApplyingFilterId(filter.getId());
        }
    }

    void validateWidgetFields(Widget newWidget, UserFilter newFilter, Widget widget, String userName, String projectName) {
        ContentOptions contentOptions = newWidget.getContentOptions();
        if (newFilter == null && null == contentOptions) {
            return;
        }
        Class<TestItem> target = null;
        if (null == contentOptions || GadgetTypes.findByName((String)contentOptions.getGadgetType()).isPresent() && GadgetTypes.findByName((String)contentOptions.getGadgetType()).get() != GadgetTypes.ACTIVITY && GadgetTypes.findByName((String)contentOptions.getGadgetType()).get() != GadgetTypes.MOST_FAILED_TEST_CASES && GadgetTypes.findByName((String)contentOptions.getGadgetType()).get() != GadgetTypes.PASSING_RATE_PER_LAUNCH) {
            if (newFilter == null) {
                UserFilter currentFilter = this.filterRepository.findOneLoadACLAndType(userName, widget.getApplyingFilterId(), projectName);
                BusinessRule.expect((Object)currentFilter, (Predicate)Predicates.notNull()).verify(ErrorType.BAD_UPDATE_WIDGET_REQUEST, new Object[]{Suppliers.formattedSupplier((String)"Unable update widget content parameters. Please specify new filter for widget. Current filter with id {} removed.", (Object[])new Object[]{widget.getApplyingFilterId()})});
                target = currentFilter.getFilter().getTarget();
            } else {
                target = newFilter.getFilter().getTarget();
            }
        }
        if (null != contentOptions) {
            if (TestItem.class.equals((Object)target)) {
                this.removeLaunchSpecificFields(contentOptions);
            }
            WidgetUtils.validateWidgetDataType((String)contentOptions.getType(), (ErrorType)ErrorType.BAD_UPDATE_WIDGET_REQUEST);
            WidgetUtils.validateGadgetType((String)contentOptions.getGadgetType(), (ErrorType)ErrorType.BAD_UPDATE_WIDGET_REQUEST);
            if (GadgetTypes.findByName((String)contentOptions.getGadgetType()).get() == GadgetTypes.ACTIVITY) {
                target = Activity.class;
            }
            if (GadgetTypes.findByName((String)contentOptions.getGadgetType()).get() == GadgetTypes.MOST_FAILED_TEST_CASES) {
                target = TestItem.class;
            }
            if (GadgetTypes.findByName((String)contentOptions.getGadgetType()).get() == GadgetTypes.PASSING_RATE_PER_LAUNCH) {
                target = Launch.class;
            }
            CriteriaMap criteriaMap = this.criteriaMapFactory.getCriteriaMap(target);
            if (null != contentOptions.getContentFields()) {
                WidgetUtils.validateFields((Iterable)contentOptions.getContentFields(), (CriteriaMap)criteriaMap, (ErrorType)ErrorType.BAD_UPDATE_WIDGET_REQUEST);
            }
            if (null != contentOptions.getMetadataFields()) {
                WidgetUtils.validateFields((Iterable)contentOptions.getMetadataFields(), (CriteriaMap)criteriaMap, (ErrorType)ErrorType.BAD_UPDATE_WIDGET_REQUEST);
            }
        }
    }

    void removeLaunchSpecificFields(ContentOptions contentOptions) {
        if (null != contentOptions.getMetadataFields() && contentOptions.getMetadataFields().contains("number")) {
            contentOptions.getMetadataFields().remove("number");
        }
        if (null != contentOptions.getContentFields() && contentOptions.getContentFields().contains("number")) {
            contentOptions.getContentFields().remove("number");
        }
        if (null != contentOptions.getContentFields() && contentOptions.getContentFields().contains("user")) {
            contentOptions.getContentFields().remove("user");
        }
    }
}

