/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.events.ProjectUpdatedEvent;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.project.ProjectConfiguration;
import java.util.HashMap;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ProjectActivityHandler {
    public static final String UPDATE_PROJECT = "update_project";
    public static final String KEEP_SCREENSHOTS = "keepScreenshots";
    public static final String KEEP_LOGS = "keepLogs";
    public static final String LAUNCH_INACTIVITY = "launchInactivity";
    public static final String STATISTICS_CALCULATION_STRATEGY = "statisticsCalculationStrategy";
    public static final String AUTO_ANALYZE = "auto_analyze";
    private final ActivityRepository activityRepository;
    private final Provider<ActivityBuilder> activityBuilder;

    @Autowired
    public ProjectActivityHandler(Provider<ActivityBuilder> activityBuilder, ActivityRepository activityRepository) {
        this.activityBuilder = activityBuilder;
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onApplicationEvent(ProjectUpdatedEvent event) {
        Project project = (Project)event.getBefore();
        HashMap history = new HashMap();
        ProjectConfiguration configuration = event.getUpdateProjectRQ().getConfiguration();
        if (null != configuration) {
            this.processKeepLogs(history, project, configuration);
            this.processKeepScreenshots(history, project, configuration);
            this.processLaunchInactivityTimeout(history, project, configuration);
            this.processAutoAnalyze(history, project, configuration);
            this.processStatisticsStrategy(history, project, configuration);
        }
        if (!history.isEmpty()) {
            Activity activityLog = (Activity)((ActivityBuilder)this.activityBuilder.get()).addProjectRef(project.getName()).addObjectType("project").addActionType(UPDATE_PROJECT).addUserRef(event.getUpdatedBy()).build();
            activityLog.setHistory(history);
            this.activityRepository.save((Object)activityLog);
        }
    }

    private void processStatisticsStrategy(HashMap<String, Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getStatisticCalculationStrategy() && !configuration.getStatisticCalculationStrategy().equalsIgnoreCase(project.getConfiguration().getStatisticsCalculationStrategy().name())) {
            Activity.FieldValues fieldValues = Activity.FieldValues.newOne().withOldValue(project.getConfiguration().getStatisticsCalculationStrategy().name()).withNewValue(configuration.getStatisticCalculationStrategy());
            history.put(STATISTICS_CALCULATION_STRATEGY, fieldValues);
        }
    }

    private void processKeepLogs(HashMap<String, Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getKeepLogs() && !configuration.getKeepLogs().equals(project.getConfiguration().getKeepLogs())) {
            Activity.FieldValues fieldValues = Activity.FieldValues.newOne().withOldValue(project.getConfiguration().getKeepLogs()).withNewValue(configuration.getKeepLogs());
            history.put(KEEP_LOGS, fieldValues);
        }
    }

    private void processLaunchInactivityTimeout(HashMap<String, Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getInterruptJobTime() && !configuration.getInterruptJobTime().equals(project.getConfiguration().getInterruptJobTime())) {
            Activity.FieldValues fieldValues = Activity.FieldValues.newOne().withOldValue(project.getConfiguration().getInterruptJobTime()).withNewValue(configuration.getInterruptJobTime());
            history.put(LAUNCH_INACTIVITY, fieldValues);
        }
    }

    private void processAutoAnalyze(HashMap<String, Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getIsAAEnabled() && !configuration.getIsAAEnabled().equals(project.getConfiguration().getIsAutoAnalyzerEnabled())) {
            Activity.FieldValues fieldValues = Activity.FieldValues.newOne().withOldValue(project.getConfiguration().getIsAutoAnalyzerEnabled() == null ? "" : project.getConfiguration().getIsAutoAnalyzerEnabled().toString()).withNewValue(configuration.getIsAAEnabled().toString());
            history.put(AUTO_ANALYZE, fieldValues);
        }
    }

    private void processKeepScreenshots(HashMap<String, Activity.FieldValues> history, Project project, ProjectConfiguration configuration) {
        if (null != configuration.getKeepScreenshots() && !configuration.getKeepScreenshots().equals(project.getConfiguration().getKeepScreenshots())) {
            Activity.FieldValues fieldValues = Activity.FieldValues.newOne().withOldValue(project.getConfiguration().getKeepScreenshots()).withNewValue(configuration.getKeepScreenshots());
            history.put(KEEP_SCREENSHOTS, fieldValues);
        }
    }
}

