/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.filter.ICreateUserFilterHandler;
import com.epam.ta.reportportal.core.filter.IDeleteUserFilterHandler;
import com.epam.ta.reportportal.core.filter.IGetUserFilterHandler;
import com.epam.ta.reportportal.core.filter.IUpdateUserFilterHandler;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.controller.IUserFilterController;
import com.epam.ta.reportportal.ws.model.CollectionsRQ;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.filter.BulkUpdateFilterRQ;
import com.epam.ta.reportportal.ws.model.filter.CreateUserFilterRQ;
import com.epam.ta.reportportal.ws.model.filter.UpdateUserFilterRQ;
import com.epam.ta.reportportal.ws.model.filter.UserFilterResource;
import com.epam.ta.reportportal.ws.resolver.ActiveRole;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/{projectName}/filter"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class UserFilterController
implements IUserFilterController {
    @Autowired
    private ICreateUserFilterHandler createFilterHandler;
    @Autowired
    private IGetUserFilterHandler getFilterHandler;
    @Autowired
    private IDeleteUserFilterHandler deleteFilterHandler;
    @Autowired
    private IUpdateUserFilterHandler updateUserFilterHandler;

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Create user filter")
    public List<EntryCreatedRS> createFilter(@PathVariable String projectName, @RequestBody @Validated CollectionsRQ<CreateUserFilterRQ> createFilterRQ, Principal principal) {
        return this.createFilterHandler.createFilter(principal.getName(), EntityUtils.normalizeId((String)projectName), createFilterRQ);
    }

    @RequestMapping(value={"/{filterId}"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get specified user filter by id")
    public UserFilterResource getFilter(@PathVariable String projectName, @PathVariable String filterId, Principal principal) {
        return this.getFilterHandler.getFilter(principal.getName(), filterId, EntityUtils.normalizeId((String)projectName));
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all filters")
    public Iterable<UserFilterResource> getAllFilters(@PathVariable String projectName, @SortFor(value=UserFilter.class) Pageable pageable, @FilterFor(value=UserFilter.class) Filter filter, Principal principal) {
        return this.getFilterHandler.getFilters(principal.getName(), pageable, filter, EntityUtils.normalizeId((String)projectName));
    }

    @RequestMapping(value={"/own"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all filters for specified user who own them")
    public List<UserFilterResource> getOwnFilters(@PathVariable String projectName, @FilterFor(value=UserFilter.class) Filter filter, Principal principal) {
        return this.getFilterHandler.getOwnFilters(principal.getName(), filter, EntityUtils.normalizeId((String)projectName));
    }

    @RequestMapping(value={"/shared"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all available shared filters (except own shared filters)")
    public List<UserFilterResource> getSharedFilters(@PathVariable String projectName, @FilterFor(value=UserFilter.class) Filter filter, Principal principal) {
        return this.getFilterHandler.getSharedFilters(principal.getName(), filter, EntityUtils.normalizeId((String)projectName));
    }

    @RequestMapping(value={"/{filterId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete specified user filter by id")
    public OperationCompletionRS deleteFilter(@PathVariable String projectName, @PathVariable String filterId, @ActiveRole UserRole userRole, Principal principal) {
        return this.deleteFilterHandler.deleteFilter(filterId, principal.getName(), EntityUtils.normalizeId((String)projectName), userRole);
    }

    @RequestMapping(value={"/names"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get available filter names")
    public Map<String, SharedEntity> getAllFiltersNames(@PathVariable String projectName, Principal principal, @RequestParam(value="share", defaultValue="false", required=false) boolean isShared) {
        return this.getFilterHandler.getFiltersNames(principal.getName(), EntityUtils.normalizeId((String)projectName), isShared);
    }

    @RequestMapping(value={"/{filterId}"}, method={RequestMethod.PUT})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update specified user filter")
    public OperationCompletionRS updateUserFilter(@PathVariable String projectName, @PathVariable String filterId, @RequestBody @Validated UpdateUserFilterRQ updateRQ, Principal principal, @ActiveRole UserRole userRole) {
        return this.updateUserFilterHandler.updateUserFilter(filterId, updateRQ, principal.getName(), EntityUtils.normalizeId((String)projectName), userRole);
    }

    @RequestMapping(value={"/filters"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get list of specified user filters")
    public List<UserFilterResource> getUserFilters(@PathVariable String projectName, @RequestParam(value="ids", required=true) String[] ids, Principal principal) {
        return this.getFilterHandler.getFilters(EntityUtils.normalizeId((String)projectName), ids, principal.getName());
    }

    @RequestMapping(method={RequestMethod.PUT})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update list of user filters")
    public List<OperationCompletionRS> updateUserFilters(@PathVariable String projectName, @RequestBody @Validated CollectionsRQ<BulkUpdateFilterRQ> updateRQ, Principal principal, @ActiveRole UserRole userRole) {
        return this.updateUserFilterHandler.updateUserFilter(updateRQ, principal.getName(), EntityUtils.normalizeId((String)projectName), userRole);
    }
}

