/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.entity.AuthType;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.item.issue.ExternalSystemType;
import com.epam.ta.reportportal.ws.converter.builders.Builder;
import com.epam.ta.reportportal.ws.model.externalsystem.CreateExternalSystemRQ;
import org.jasypt.util.text.BasicTextEncryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class ExternalSystemBuilder
extends Builder<ExternalSystem> {
    @Autowired
    private BasicTextEncryptor simpleEncryptor;

    public ExternalSystemBuilder addExternalSystem(CreateExternalSystemRQ request, String rpProject) {
        ((ExternalSystem)this.getObject()).setExternalSystemType((ExternalSystemType)ExternalSystemType.findByName((String)request.getExternalSystemType()).orElse(null));
        ((ExternalSystem)this.getObject()).setUrl(request.getUrl());
        ((ExternalSystem)this.getObject()).setExternalSystemAuth(AuthType.findByName((String)request.getExternalSystemAuth()));
        ((ExternalSystem)this.getObject()).setProjectRef(rpProject);
        ((ExternalSystem)this.getObject()).setProject(request.getProject());
        ((ExternalSystem)this.getObject()).setUsername(request.getUsername());
        String encryptedPass = this.simpleEncryptor.encrypt(request.getPassword());
        ((ExternalSystem)this.getObject()).setPassword(encryptedPass);
        ((ExternalSystem)this.getObject()).setAccessKey(request.getAccessKey());
        ((ExternalSystem)this.getObject()).setDomain(request.getDomain());
        return this;
    }

    protected ExternalSystem initObject() {
        return new ExternalSystem();
    }
}

