/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.entity.filter.ObjectType;
import com.epam.ta.reportportal.database.entity.filter.SelectionOptions;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.ws.converter.builders.ShareableEntityBuilder;
import com.epam.ta.reportportal.ws.model.filter.CreateUserFilterRQ;
import com.epam.ta.reportportal.ws.model.filter.SelectionParameters;
import com.epam.ta.reportportal.ws.model.filter.UserFilterEntity;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class UserFilterBuilder
extends ShareableEntityBuilder<UserFilter> {
    public UserFilterBuilder addCreateRQ(CreateUserFilterRQ request) {
        if (request != null) {
            ((UserFilter)this.getObject()).setName(request.getName().trim());
            ((UserFilter)this.getObject()).setIsLink(request.getIsLink());
            Set filterEntities = request.getEntities();
            ((UserFilter)this.getObject()).setFilter(this.getFilter(filterEntities, request.getObjectType()));
            this.addSelectionParamaters(request.getSelectionParameters());
        }
        return this;
    }

    public UserFilterBuilder addSelectionParamaters(SelectionParameters parameters) {
        if (parameters != null) {
            SelectionOptions selectionOptions = new SelectionOptions();
            selectionOptions.setIsAsc(parameters.getIsAsc());
            selectionOptions.setSortingColumnName(parameters.getSortingColumnName());
            selectionOptions.setPageNumber(parameters.getPageNumber());
            ((UserFilter)this.getObject()).setSelectionOptions(selectionOptions);
        }
        return this;
    }

    public UserFilterBuilder addSharing(String owner, String project, String description, boolean isShare) {
        super.addAcl(owner, project, description, isShare);
        return this;
    }

    public UserFilterBuilder addProject(String projectName) {
        ((UserFilter)this.getObject()).setProjectName(projectName);
        return this;
    }

    protected UserFilter initObject() {
        return new UserFilter();
    }

    private Filter getFilter(Set<UserFilterEntity> filterEntities, String objectType) {
        if (filterEntities == null) {
            return null;
        }
        LinkedHashSet<FilterCondition> filterConditions = new LinkedHashSet<FilterCondition>(filterEntities.size());
        for (UserFilterEntity filterEntity : filterEntities) {
            Condition conditionObject = Condition.findByMarker((String)filterEntity.getCondition());
            FilterCondition filterCondition = new FilterCondition(conditionObject, filterEntity.getIsNegative(), filterEntity.getValue().trim(), filterEntity.getFilteringField().trim());
            filterConditions.add(filterCondition);
        }
        return new Filter(ObjectType.getTypeByName((String)objectType), filterConditions);
    }
}

