/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.converters;

import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.ws.model.widget.ContentParameters;
import com.epam.ta.reportportal.ws.model.widget.WidgetResource;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Function;

public final class WidgetConverter {
    public static final Function<Widget, WidgetResource> TO_RESOURCE = widget -> {
        Preconditions.checkNotNull((Object)widget);
        WidgetResource widgetResource = new WidgetResource();
        widgetResource.setWidgetId(widget.getId());
        widgetResource.setName(widget.getName());
        widgetResource.setDescription(widget.getDescription());
        widgetResource.setApplyingFilterID(widget.getApplyingFilterId());
        Optional.ofNullable(widget.getContentOptions()).ifPresent(options -> {
            ContentParameters contentParameters = new ContentParameters();
            contentParameters.setType(options.getType());
            contentParameters.setGadget(options.getGadgetType());
            contentParameters.setMetadataFields(options.getMetadataFields());
            contentParameters.setContentFields(options.getContentFields());
            contentParameters.setItemsCount(options.getItemsCount());
            contentParameters.setWidgetOptions(options.getWidgetOptions());
            widgetResource.setContentParameters(contentParameters);
        });
        Optional.ofNullable(widget.getAcl()).ifPresent(acl -> {
            widgetResource.setOwner(acl.getOwnerUserId());
            widgetResource.setShare(!acl.getEntries().isEmpty());
        });
        return widgetResource;
    };

    private WidgetConverter() {
    }
}

