/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.dashboard.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.dashboard.ICreateDashboardHandler;
import com.epam.ta.reportportal.database.dao.DashboardRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.ws.converter.builders.DashboardBuilder;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.dashboard.CreateDashboardRQ;
import java.util.function.Predicate;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateDashboardHandler
implements ICreateDashboardHandler {
    @Autowired
    private DashboardRepository dashboardRepository;
    @Autowired
    private Provider<DashboardBuilder> dashboardBuilder;

    public EntryCreatedRS createDashboard(String projectName, CreateDashboardRQ rq, String userName) {
        rq.setName(rq.getName().trim());
        Dashboard isExist = this.dashboardRepository.findOneByUserProject(userName, projectName, rq.getName());
        BusinessRule.expect((Object)isExist, (Predicate)Predicates.isNull()).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{rq.getName()});
        Dashboard dashboard = (Dashboard)((DashboardBuilder)this.dashboardBuilder.get()).addCreateDashboardRQ(rq).addSharing(userName, projectName, rq.getDescription(), rq.getShare() == null ? false : rq.getShare()).addProject(projectName).build();
        this.dashboardRepository.save((Object)dashboard);
        return new EntryCreatedRS(dashboard.getId());
    }
}

