/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.externalsystem.handler.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.externalsystem.ExternalSystemStrategy;
import com.epam.ta.reportportal.core.externalsystem.StrategyProvider;
import com.epam.ta.reportportal.core.externalsystem.handler.IGetTicketHandler;
import com.epam.ta.reportportal.database.dao.ExternalSystemRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.externalsystem.PostFormField;
import com.epam.ta.reportportal.ws.model.externalsystem.Ticket;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetTicketHandler
implements IGetTicketHandler {
    private final StrategyProvider strategyProvider;
    private final ProjectRepository projectRepository;
    private final ExternalSystemRepository externalSystemRepository;

    @Autowired
    public GetTicketHandler(StrategyProvider strategyProvider, ProjectRepository projectRepository, ExternalSystemRepository externalSystemRepository) {
        this.strategyProvider = strategyProvider;
        this.projectRepository = projectRepository;
        this.externalSystemRepository = externalSystemRepository;
    }

    public Ticket getTicket(String ticketId, String projectName, String systemId) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        List ids = project.getConfiguration().getExternalSystem();
        BusinessRule.expect((Object)ids, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_CONFIGURED, new Object[]{projectName});
        ExternalSystem system = (ExternalSystem)this.externalSystemRepository.findOne((Serializable)((Object)systemId));
        BusinessRule.expect((Object)system, (Predicate)Predicates.notNull()).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{systemId});
        ExternalSystemStrategy externalSystemStrategy = this.strategyProvider.getStrategy(system.getExternalSystemType().name());
        return externalSystemStrategy.getTicket(ticketId, system).orElse(null);
    }

    public List<PostFormField> getSubmitTicketFields(String ticketType, String projectName, String systemId) {
        this.validateProject(projectName);
        ExternalSystem system = this.validateExternalSystem(systemId);
        ExternalSystemStrategy externalSystemStrategy = this.strategyProvider.getStrategy(system.getExternalSystemType().name());
        return externalSystemStrategy.getTicketFields(ticketType, system);
    }

    public List<String> getAllowableIssueTypes(String projectName, String systemId) {
        this.validateProject(projectName);
        ExternalSystem system = this.validateExternalSystem(systemId);
        ExternalSystemStrategy externalSystemStrategy = this.strategyProvider.getStrategy(system.getExternalSystemType().name());
        return externalSystemStrategy.getIssueTypes(system);
    }

    private void validateProject(String projectName) {
        BusinessRule.expect((Object)this.projectRepository.exists((Serializable)((Object)projectName)), exists -> exists).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
    }

    private ExternalSystem validateExternalSystem(String systemId) {
        ExternalSystem system = (ExternalSystem)this.externalSystemRepository.findOne((Serializable)((Object)systemId));
        BusinessRule.expect((Object)system, (Predicate)Predicates.notNull()).verify(ErrorType.EXTERNAL_SYSTEM_NOT_FOUND, new Object[]{systemId});
        return system;
    }
}

