/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.imprt.ImportLaunchHandler;
import com.epam.ta.reportportal.core.imprt.impl.ImportStrategy;
import com.epam.ta.reportportal.core.imprt.impl.ImportStrategyFactoryImpl;
import com.epam.ta.reportportal.core.imprt.impl.ImportType;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.Serializable;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImportLaunchHandlerImpl
implements ImportLaunchHandler {
    @Autowired
    private ImportStrategyFactoryImpl factory;
    @Autowired
    private ProjectRepository projectRepository;

    public OperationCompletionRS importLaunch(String projectId, String userName, String format, MultipartFile file) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectId));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectId});
        ImportType type = (ImportType)ImportType.fromValue((String)format).orElseThrow(() -> new ReportPortalException(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect importing file format: " + format}));
        ImportStrategy strategy = this.factory.getImportLaunch(type);
        String launch = strategy.importLaunch(projectId, userName, file);
        return new OperationCompletionRS("Launch with id = " + launch + " is successfully imported.");
    }
}

