/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.launch.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.launch.IGetLaunchHandler;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.statistics.ExecutionCounter;
import com.epam.ta.reportportal.database.entity.statistics.IssueCounter;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.converter.LaunchResourceAssembler;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class GetLaunchHandler
extends StatisticBasedContentLoader
implements IGetLaunchHandler {
    private ProjectRepository projectRepository;
    private final LaunchRepository launchRepository;
    private final LaunchResourceAssembler launchResourceAssembler;

    @Autowired
    public GetLaunchHandler(LaunchResourceAssembler launchResourceAssembler, LaunchRepository launchRepository) {
        this.launchResourceAssembler = (LaunchResourceAssembler)Preconditions.checkNotNull((Object)launchResourceAssembler);
        this.launchRepository = (LaunchRepository)Preconditions.checkNotNull((Object)launchRepository);
    }

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    public LaunchResource getLaunch(String launchId, String userName, String projectName) {
        Launch launch = this.validate(launchId, projectName);
        if (launch.getMode() == Mode.DEBUG) {
            Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
            Project.UserConfig userConfig = ProjectUtils.findUserConfigByLogin((Project)project, (String)userName);
            BusinessRule.expect((Object)userConfig.getProjectRole(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)ProjectRole.CUSTOMER))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
        return this.launchResourceAssembler.toResource(launch);
    }

    public LaunchResource getLaunchByName(String project, Pageable pageable, Filter filter, String username) {
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, project, "project"));
        Page launches = this.launchRepository.findByFilter((Queryable)filter, pageable);
        BusinessRule.expect((Object)launches, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[0]);
        return this.launchResourceAssembler.toResource((Launch)launches.iterator().next());
    }

    public Iterable<LaunchResource> getProjectLaunches(String projectName, Filter filter, Pageable pageable, String userName) {
        this.validateModeConditions(filter);
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, projectName, "project"));
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, Mode.DEFAULT.toString(), "mode"));
        Page launches = this.launchRepository.findByFilter((Queryable)filter, pageable);
        return this.launchResourceAssembler.toPagedResources(launches);
    }

    public Iterable<LaunchResource> getDebugLaunches(String projectName, String userName, Filter filter, Pageable pageable) {
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, projectName, "project"));
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, Mode.DEBUG.toString(), "mode"));
        Page launches = this.launchRepository.findByFilter((Queryable)filter, pageable);
        return this.launchResourceAssembler.toPagedResources(launches);
    }

    public com.epam.ta.reportportal.ws.model.Page<LaunchResource> getLatestLaunches(String projectName, Filter filter, Pageable pageable) {
        this.validateModeConditions(filter);
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, Mode.DEFAULT.toString(), "mode"));
        filter.addCondition(new FilterCondition(Condition.EQUALS, false, projectName, "project"));
        Page resources = this.launchRepository.findLatestLaunches((Queryable)filter, pageable).map(arg_0 -> ((LaunchResourceAssembler)this.launchResourceAssembler).toResource(arg_0));
        return new com.epam.ta.reportportal.ws.model.Page((Collection)resources.getContent(), (long)resources.getSize(), (long)(resources.getNumber() + 1), resources.getTotalElements(), (long)resources.getTotalPages());
    }

    public List<String> getTags(String project, String value) {
        return this.launchRepository.findDistinctValues(project, value, "tags");
    }

    public List<String> getLaunchNames(String project, String value) {
        BusinessRule.expect((Object)(value.length() > 2 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the launch name string '{}' is less than 3 symbols", (Object[])new Object[]{value})});
        return this.launchRepository.findValuesWithMode(project, value, "name", Mode.DEFAULT.name());
    }

    public List<String> getOwners(String project, String value, String field, String mode) {
        BusinessRule.expect((Object)(value.length() > 2 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{Suppliers.formattedSupplier((String)"Length of the filtering string '{}' is less than 3 symbols", (Object[])new Object[]{value})});
        return this.launchRepository.findValuesWithMode(project, value, field, mode);
    }

    public Map<String, List<ChartObject>> getLaunchesComparisonInfo(String projectName, String[] ids) {
        List launches = this.launchRepository.find(Arrays.asList(ids));
        ArrayList objects = new ArrayList(launches.size());
        launches.forEach(launch -> {
            ChartObject object = new ChartObject();
            object.setName(launch.getName());
            object.setStartTime(String.valueOf(launch.getStartTime().getTime()));
            object.setNumber(String.valueOf(launch.getNumber()));
            object.setId(launch.getId());
            IssueCounter issueCounter = launch.getStatistics().getIssueCounter();
            ImmutableMap issuesData = ImmutableMap.builder().put((Object)this.getProductBugFieldName().replaceAll("\\.", "\\$"), (Object)issueCounter.getProductBugTotal()).put((Object)this.getSystemIssueFieldName().replaceAll("\\.", "\\$"), (Object)issueCounter.getSystemIssueTotal()).put((Object)this.getAutomationBugFieldName().replaceAll("\\.", "\\$"), (Object)issueCounter.getAutomationBugTotal()).put((Object)this.getToInvestigateFieldName().replaceAll("\\.", "\\$"), (Object)issueCounter.getToInvestigateTotal()).build();
            ExecutionCounter executionCounter = launch.getStatistics().getExecutionCounter();
            ImmutableMap executionData = ImmutableMap.builder().put((Object)this.getFailedFieldName().replaceAll("\\.", "\\$"), (Object)executionCounter.getFailed()).put((Object)this.getPassedFieldName().replaceAll("\\.", "\\$"), (Object)executionCounter.getPassed()).put((Object)this.getSkippedFieldName().replaceAll("\\.", "\\$"), (Object)executionCounter.getSkipped()).build();
            Map computedStatistics = this.computeFraction((Map)issuesData);
            computedStatistics.putAll(this.computeFraction((Map)executionData));
            object.setValues(computedStatistics);
            objects.add(object);
        });
        return Collections.singletonMap("result", objects);
    }

    public Map<String, String> getStatuses(String projectName, String[] ids) {
        return this.launchRepository.find(Arrays.asList(ids)).stream().filter(launch -> launch.getProjectRef().equals(projectName)).collect(Collectors.toMap(Launch::getId, launch -> launch.getStatus().toString()));
    }

    private Map<String, String> computeFraction(Map<String, Integer> data) {
        HashMap<String, String> result = new HashMap<String, String>();
        DecimalFormat formatter = new DecimalFormat("###.##");
        int total = data.values().stream().mapToInt(Integer::intValue).sum();
        String lastKey = null;
        Double lastValue = 0.0;
        Double sum = 0.0;
        Set<Map.Entry<String, Integer>> entries = data.entrySet();
        for (Map.Entry<String, Integer> entry : entries) {
            String formattedValue = formatter.format(total != 0 ? (double)entry.getValue().intValue() / (double)total * 100.0 : 0.0);
            lastKey = entry.getKey();
            lastValue = Double.valueOf(formattedValue);
            sum = sum + lastValue;
            result.put(entry.getKey(), formattedValue);
        }
        if (total != 0) {
            result.put(lastKey, formatter.format(100.0 - (sum - lastValue)));
        }
        return result;
    }

    private void validateModeConditions(Filter filter) {
        BusinessRule.expect((Object)filter.getFilterConditions().stream().anyMatch(com.epam.ta.reportportal.commons.Preconditions.HAS_ANY_MODE), (Predicate)Predicates.equalTo((Object)false)).verify(ErrorType.INCORRECT_FILTER_PARAMETERS, new Object[]{"Filters for 'mode' aren't applicable for project's launches."});
    }

    private Launch validate(String launchId, String projectName) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        BusinessRule.expect((Object)launch, (Predicate)Predicates.notNull()).verify(ErrorType.LAUNCH_NOT_FOUND, new Object[]{launchId});
        BusinessRule.expect((Object)launch.getProjectRef(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Specified launch with id '{}' not referenced to specified project '{}'", (Object[])new Object[]{launchId, projectName})});
        return launch;
    }
}

