/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.log.impl;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.log.IDeleteLogHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectRole;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.Serializable;
import java.util.Collections;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteLogHandler
implements IDeleteLogHandler {
    private LogRepository logRepository;
    private TestItemRepository testItemRepository;
    private LaunchRepository launchRepository;
    private ProjectRepository projectRepository;
    private UserRepository userRepository;

    @Autowired
    public void setLaunchRepository(LaunchRepository launchRepository) {
        this.launchRepository = launchRepository;
    }

    @Autowired
    public void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    @Autowired
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Autowired
    public void setTestItemRepository(TestItemRepository itemRepository) {
        this.testItemRepository = itemRepository;
    }

    @Autowired
    public void setLogRepository(LogRepository logRepository) {
        this.logRepository = logRepository;
    }

    public OperationCompletionRS deleteLog(String logId, String projectName, String userName) {
        User user = this.userRepository.findOne(userName);
        BusinessRule.expect((Object)user, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{userName});
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)projectName));
        BusinessRule.expect((Object)project, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{projectName});
        Log log = this.validate(logId, projectName);
        this.validateRoles(log, user, project);
        try {
            this.logRepository.delete((Object)log);
        }
        catch (Exception exc) {
            throw new ReportPortalException("Error while Log instance deleting.", (Throwable)exc);
        }
        return new OperationCompletionRS("Log with ID = '" + logId + "' successfully deleted.");
    }

    private Log validate(String logId, String projectName) {
        Log log = (Log)this.logRepository.findOne((Serializable)((Object)logId));
        BusinessRule.expect((Object)log, (Predicate)Predicates.notNull()).verify(ErrorType.LOG_NOT_FOUND, new Object[]{logId});
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)log.getTestItemRef()));
        BusinessRule.expect((Object)testItem, (Predicate)Predicates.not((Predicate)Preconditions.IN_PROGRESS)).verify(ErrorType.TEST_ITEM_IS_NOT_FINISHED, new Object[]{Suppliers.formattedSupplier((String)"Unable to delete log '{}' when test item '{}' in progress state", (Object[])new Object[]{log.getId(), testItem.getId()})});
        String expectedProjectName = ((Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()))).getProjectRef();
        BusinessRule.expect((Object)expectedProjectName, (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{Suppliers.formattedSupplier((String)"Log '{}' not under specified '{}' project", (Object[])new Object[]{logId, projectName})});
        return log;
    }

    private void validateRoles(Log log, User user, Project project) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)log.getTestItemRef()));
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)testItem.getLaunchRef()));
        if (user.getRole() != UserRole.ADMINISTRATOR && !user.getId().equalsIgnoreCase(launch.getUserRef())) {
            Project.UserConfig userConfig = ProjectUtils.findUserConfigByLogin((Project)project, (String)user.getId());
            BusinessRule.expect((Object)userConfig, (Predicate)Preconditions.hasProjectRoles(Collections.singletonList(ProjectRole.PROJECT_MANAGER))).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        }
    }
}

